/**
 * @(#)CsLockOrderQueryApi.java 1.0 2022/05/30 15:48
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLockOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLockOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
* CsLockOrderQueryApi
*
* @author wenyi
* @Date: 2022/05/30 15:48
* @since 1.0.0
*/
@Api(tags = {"CsLockOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csLockOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLockOrderQueryApi {
    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @Deprecated
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询 请调用报表中心api", notes = "分页查询 请调用报表中心api")
    RestResponse<PageInfo<CsLockOrderRespDto>> queryByPage(@Validated @RequestBody CsLockOrderQueryDto queryDto);

}