package com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.BatchCancelLogicAndPhysicsOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderComReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsTransferOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsTransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOrderSalesRefundReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicPreemptInventoryAndAddSaleTransferOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicPreemptInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutDeliveryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsWmsShippingInfoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsPcpInventoryExposedRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsPcpShippingInfoListRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * PCP-库存中心暴露对外操作接口
 *
 * @author jingran-
 * @version 1.0
 * @Date 2022/1/14 1:47 下午
 */
@Api(tags = {"PCP-库存中心暴露对外操作接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csPcpInventoryExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsPcpInventoryExposedApi {

    /**
     * 预占逻辑仓库存、物理仓库存,生成发货通知单，根据条件判断是否生成出库通知单
     *
     * @param logicPreemptInventoryOperateReqDto
     * @return
     */
    @PostMapping(value = "/preemptOrderInventory", produces = "application/json")
    @ApiOperation(value = "预占逻辑仓库存、物理仓库存,生成发货通知单，根据条件判断是否生成出库通知单", notes = "预占逻辑仓库存、物理仓库存,生成发货通知单，根据条件判断是否生成出库通知单")
    RestResponse<CsPcpInventoryExposedRespDto> preemptOrderInventory(@Validated @RequestBody CsLogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto);

    /**
     * 预占逻辑仓库存、物理仓库存,生成发货通知单，根据条件判断是否生成出库通知单
     *
     * @param logicPreemptInventoryOperateReqDtos
     * @return
     */
    @PostMapping(value = "/preemptOrderInventoryBatch", produces = "application/json")
    @ApiOperation(value = "预占逻辑仓库存、物理仓库存,生成发货通知单，根据条件判断是否生成出库通知单", notes = "预占逻辑仓库存、物理仓库存,生成发货通知单，根据条件判断是否生成出库通知单")
    RestResponse<List<CsPcpInventoryExposedRespDto>> preemptOrderInventoryBatch(@Validated @RequestBody List<CsLogicPreemptInventoryOperateReqDto> logicPreemptInventoryOperateReqDtos);

    /**
     * 根据订单号取消订单
     * 释放预占的渠道仓、逻辑仓、物理仓库存信息，将发货通知单、出库通知单置为取消状态
     *
     * @param orderNo
     * @return
     */
    @Deprecated
    @GetMapping(value = "/{orderNo}/cancelOrder", produces = "application/json")
    @ApiOperation(value = "根据订单号取消订单，释放预占的渠道仓、逻辑仓、物理仓库存信息，将发货通知单、出库通知单置为取消状态", notes = "根据订单号取消订单，释放预占的渠道仓、逻辑仓、物理仓库存信息，将发货通知单、出库通知单置为取消状态")
    RestResponse<Boolean> cancelOrder(@PathVariable("orderNo") String orderNo);

    /**
     * 根据订单号取消订单
     * 释放预占的逻辑仓、物理仓库存信息，将发货通知单、出库通知单置为取消状态
     * 不释放渠道仓预占的库存
     *
     * @param orderNo
     * @return
     */
    @GetMapping(value = "/{orderNo}/cancelLogicAndPhysicsOrder", produces = "application/json")
    @ApiOperation(value = "根据订单号取消订单,释放预占的逻辑仓、物理仓库存信息，将发货通知单、出库通知单置为取消状态", notes = "根据订单号取消订单,释放预占的逻辑仓、物理仓库存信息，将发货通知单、出库通知单置为取消状态")
    RestResponse<Boolean> cancelLogicAndPhysicsOrder(@PathVariable("orderNo") String orderNo);

    @GetMapping(value = "/{orderNo}/cancellationNotice", produces = "application/json")
    @ApiOperation(value = "根据订单号取消入库通知单、收货通知单置为取消状态", notes = "根据订单号取消入库通知单、收货通知单置为取消状态")
    RestResponse<Boolean> cancellationNotice(@PathVariable("orderNo") String orderNo);


    /**
     * 根据订单号释放逻辑仓预占库存，取消发货通知单
     *
     * @param orderNo
     * @return
     */
    @GetMapping(value = "/{orderNo}/cancelLogicOrder", produces = "application/json")
    @ApiOperation(value = "根据订单号释放逻辑仓预占库存，取消发货通知单", notes = "根据订单号释放逻辑仓预占库存，取消发货通知单")
    RestResponse<Boolean> cancelLogicOrder(@PathVariable("orderNo") String orderNo);

    /**
     * 根据订单号释放物理仓预占库存，取消出库通知单
     *
     * @param orderNo
     * @return
     */
    @GetMapping(value = "/{orderNo}/cancelPhysicsOrder", produces = "application/json")
    @ApiOperation(value = "根据订单号释放物理仓预占库存，取消出库通知单", notes = "根据订单号释放物理仓预占库存，取消出库通知单")
    RestResponse<Boolean> cancelPhysicsOrder(@PathVariable("orderNo") String orderNo);

    @PostMapping(value = "/batchCancelLogicAndPhysicsOrder", produces = "application/json")
    @ApiOperation(value = "批量取消出库通知单 和 发货通知单", notes = "批量取消出库通知单 和 发货通知单")
    RestResponse<Void> batchCancelLogicAndPhysicsOrder(@RequestBody BatchCancelLogicAndPhysicsOrderReqDto reqDto);

    /**
     * 出库
     * V2.0最小闭环模拟出库
     *
     * @param csOutDeliveryReqDto
     * @return
     */
    @PostMapping(value = "/outDelivery", produces = "application/json")
    @ApiOperation(value = "出库", notes = "出库")
    RestResponse<Boolean> outDelivery(@RequestBody CsOutDeliveryReqDto csOutDeliveryReqDto);

    /**
     * 销售退确认操作
     *
     * @param csOutDeliveryReqDto
     * @return
     */
    @PostMapping(value = "/orderSalesRefundConfirm", produces = "application/json")
    @ApiOperation(value = "销售退确认操作", notes = "销售退确认操作")
    RestResponse<Boolean> orderSalesRefundConfirm(@RequestBody CsInventoryOrderSalesRefundReqDto csOutDeliveryReqDto);

    /**
     * 销售退操作，查询是否可以进行取消操作
     * 根据销售退单号查询，是否已生成入库结果单
     *
     * @param sourceNo 销售退单的单号
     * @return true：可以取消       false：不可取消
     */
    @GetMapping(value = "/{sourceNo}/orderSalesCheckCancel", produces = "application/json")
    @ApiOperation(value = "销售退操作，查询是否可以进行取消操作", notes = "销售退操作，查询是否可以进行取消操作")
    RestResponse<Boolean> orderSalesCheckCancel(@PathVariable("sourceNo") String sourceNo);

    /**
     * 销售退操作，触发关闭单据
     *
     * @param sourceNo 销售退单的单号
     * @return true：操作正常已关闭     false:操作失败，不允许关闭
     */
    @GetMapping(value = "/{sourceNo}/orderSalesClose", produces = "application/json")
    @ApiOperation(value = "销售退操作，触发关闭单据", notes = "销售退操作，触发关闭单据")
    RestResponse<Boolean> orderSalesClose(@PathVariable("sourceNo") String sourceNo);

    /**
     * 根据销售退货单号，查询物流信息
     *
     * @param sourceNo 销售退单的单号
     */
    @GetMapping(value = "/{sourceNo}/queryLogisticsInfo", produces = "application/json")
    @ApiOperation(value = "根据销售退货单号，查询物流信息", notes = "根据销售退货单号，查询物流信息")
    RestResponse<List<CsWmsShippingInfoReqDto>> queryLogisticsInfo(@PathVariable("sourceNo") String sourceNo);

    /**
     * 批量根据销售退货单号，查询物流信息
     *
     * @param sourceNoList 关联单号集合
     * @return 关联单的物流信息
     */
    @PostMapping(value = "/queryLogisticsInfoList", produces = "application/json")
    @ApiOperation(value = "批量根据销售退货单号，查询物流信息", notes = "批量根据销售退货单号，查询物流信息")
    RestResponse<List<CsPcpShippingInfoListRespDto>> queryLogisticsInfoList(@RequestBody List<String> sourceNoList);


    @PostMapping(value = "/preemptOrderInventoryAndAddSaleTransfer", produces = "application/json")
    @ApiOperation(value = "预占逻辑仓库存、物理仓库存,生成发货通知单，根据条件判断是否生成出库通知单 & 新增销售调拨单", notes = "预占逻辑仓库存、物理仓库存,生成发货通知单，根据条件判断是否生成出库通知单 & 新增销售调拨单")
    RestResponse<Void> preemptOrderInventoryAndAddSaleTransfer(@Validated @RequestBody CsLogicPreemptInventoryAndAddSaleTransferOrderDto logicPreemptInventoryAndAddSaleTransferOrderDto);

    @PostMapping(value = "/preemptInventoryBy", produces = "application/json")
    @ApiOperation(value = "重新预占", notes = "重新预占")
    RestResponse<Void> preemptInventoryBy(@Validated @RequestBody CsTransferOrderComReqDto csTransferOrderComboReqDto);

}
