/**
 * @(#)CsItemApi.java 1.0 2022/03/10 11:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.item;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.UpdateItemDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.item.CsItemAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.item.CsItemUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;

/**
* CsItemApi
*
* @author chujian
* @Date: 2022/03/10 11:51
* @since 1.0.0
*/
@Api(tags = {"CsItem接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csItem", url = "${yundt.cube.center.inventory.api:}")
public interface ICsItemApi {

    /**
     * 添加
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加 ", notes = "添加 ")
    RestResponse<Long> add(@Validated @RequestBody CsItemAddReqDto addReqDto);

    /**
     * 修改
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改 ", notes = "修改 ")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsItemUpdateReqDto updateReqDto);

    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除 ", notes = "删除 ")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    @PostMapping("/updateSyncItem")
    @ApiOperation(value = "更新同步的商品名称等信息")
    RestResponse<Void> updateSyncItem(@RequestBody UpdateItemDto dto);

}
