/**
 * @(#)CsItemQueryApi.java 1.0 2022/03/10 11:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.item;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.CargoStorageTotalReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.item.CsItemQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.CargoStorageTotalRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.item.CsItemRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* CsItemQueryApi
*
* @author chujian
* @Date: 2022/03/10 11:51
* @since 1.0.0
*/
@Api(tags = {"CsItem接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csItem", url = "${yundt.cube.center.inventory.api:}")
public interface ICsItemQueryApi {

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息 ")
    RestResponse<CsItemRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsItemRespDto>> queryByPage(@Validated @RequestBody CsItemQueryDto queryDto);
    /**
     * 分页查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryPageByCondition", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsItemRespDto>> queryPageByCondition(@Validated @RequestBody CsItemQueryDto queryDto);

    /**
     * 参数查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询", notes = "参数查询")
    RestResponse<List<CsItemRespDto>> queryByParam(@Validated @RequestBody CsItemQueryDto queryDto);

    /**
     * 批量查询商品主数据根据商品code集合
     * @param itemCodes
     * @return
     */
    @PostMapping(value = "/queryItemByItemCodes", produces = "application/json")
    @ApiOperation(value = "批量查询商品主数据根据商品code集合", notes = "批量查询商品主数据根据商品code集合")
    RestResponse<List<CsItemRespDto>> queryItemByItemCodes(@Validated @RequestBody List<String> itemCodes);
    /**
     * 批量查询商品主数据根据商品longCode集合
     * @param itemLongCodes
     * @return
     */
    @PostMapping(value = "/queryItemByItemLongCodes", produces = "application/json")
    @ApiOperation(value = "批量查询商品主数据根据商品code集合", notes = "批量查询商品主数据根据商品code集合")
    RestResponse<List<CsItemRespDto>> queryItemByItemLongCodes(@Validated @RequestBody List<String> itemLongCodes);

    /**
     * 根据店铺ID获取商品库存
     *
     * @param cargoStorageTotalReqDto 店铺id
     * @return
     */
    @PostMapping(value = "/queryItemInventoryByShopId", produces = "application/json")
    @ApiOperation(value = "根据店铺ID获取商品库存", notes = "根据店铺ID获取商品库存")
    RestResponse<PageInfo<CargoStorageTotalRespDto>> queryItemInventoryByShopId(@Validated @RequestBody CargoStorageTotalReqDto cargoStorageTotalReqDto);

}
