/**
 * @(#)ICsBasicsOrderQueryApi.java 1.0 2022/5/27 11:10
 * <p>
 * Copyright (c) 2022, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsBasisOrderRelOrderInfoRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * ICsBasicsOrderQueryApi
 *
 * @author wenyi
 * @Date: 2022/5/27 11:10
 * @since 1.0.0
 */
@Api(tags = {"基础单据查询"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csBasicsOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsBasicsOrderQueryApi {

    /**
     * 根据关联单号查询所有基础单据详情信息
     * <p>
     * 根据关联单号查询单据信息
     *
     * @param relevanceNo 关联单号
     * @return
     */
    @GetMapping(value = "/{relevanceNo}/queryAllByRelevanceNo")
    @ApiOperation(value = "根据关联单号查询所有基础单据详情信息", notes = "根据关联单号查询所有基础单据详情信息")
    RestResponse<List<CsBasisOrderRelOrderInfoRespDto>> queryAllByRelevanceNo(@PathVariable(name = "relevanceNo") String relevanceNo);

}