/**
 * @(#)CsDeliveryNoticeOrderQueryApi.java 1.0 2021/12/29 11:08
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryNoticeOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryNoticeOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * CsDeliveryNoticeOrderQueryApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:08
 * @since 1.0.0
 */
@Api(tags = {"发货通知单接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csDeliveryNoticeOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsDeliveryNoticeOrderQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsDeliveryNoticeOrderRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 根据id查询根据单据号查询详情信息
     *
     * @param documentNo
     * @return
     */
    @GetMapping(value = "/{documentNo}/queryByDocumentNo", produces = "application/json")
    @ApiOperation(value = "根据单据号查询详情", notes = "根据单据号查询详情")
    RestResponse<CsDeliveryNoticeOrderRespDto> queryByDocumentNo(@PathVariable("documentNo") String documentNo);

    /**
     * 根据单据号查询二期详情
     *
     * @param documentNo
     * @return
     */
    @GetMapping(value = "/{documentNo}/queryByDocumentNo/versionSecond", produces = "application/json")
    @ApiOperation(value = "根据单据号查询二期详情", notes = "根据单据号查询二期详情")
    RestResponse<CsDeliveryNoticeOrderRespDto> queryVersionSecondByDocumentNo(@PathVariable("documentNo") String documentNo);

    /**
     * 根据单据号查询商品详情分页
     *
     * @param dto
     * @return
     */
    @PostMapping(value = "/detail/page", produces = "application/json")
    @ApiOperation(value = "根据单据号查询商品详情分页", notes = "根据单据号查询商品详情分页")
    RestResponse<PageInfo<CsDeliveryNoticeOrderDetailRespDto>> queryDeliveryNoticeOrderDetails(@Validated @RequestBody CsDeliveryNoticeOrderDetailQueryDto dto);
    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询发货通知单", notes = "分页查询")
    RestResponse<PageInfo<CsDeliveryNoticeOrderRespDto>> queryByPage(@Validated @RequestBody CsDeliveryNoticeOrderQueryDto queryDto);

    /**
     * 参数查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询", notes = "参数查询")
    RestResponse<List<CsDeliveryNoticeOrderRespDto>> queryByParam(@Validated @RequestBody CsDeliveryNoticeOrderQueryDto queryDto);


    @PostMapping(value = "/queryPreOrderNoIsBatch", produces = "application/json")
    @ApiOperation(value = "批量查询订单关联的发货通知单，返回没有设置批次的前置单据号（订单号）", notes = "批量查询订单关联的发货通知单，返回没有设置批次的前置单据号（订单号）")
    RestResponse<List<String>> queryPreOrderNoIsBatch(@RequestBody List<String> preOrderNoList);

}