/**
 * @(#)CsDeliveryResultOrderApi.java 1.0 2021/12/29 11:08
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDocumentExpressReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * CsDeliveryResultOrderApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:08
 * @since 1.0.0
 */
@Api(tags = {"CsDeliveryResultOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csDeliveryResultOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsDeliveryResultOrderApi {

    /**
     * 添加
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "/add", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsDeliveryResultOrderAddReqDto addReqDto);

    /**
     * 修改
     *
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsDeliveryResultOrderUpdateReqDto updateReqDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    @PostMapping(value = "/updateExpressInfo", produces = "application/json")
    @ApiOperation(value = "更新发货结果单物流信息", notes = "更新发货结果单物流信息")
    RestResponse<Void> updateExpressInfo(@Validated @RequestBody CsDocumentExpressReqDto reqDto);

    @PostMapping(value = "/importExcel")
    @ApiOperation(value = "导入发货结果单", notes = "导入发货结果单")
    RestResponse<Object> importExcel(@RequestParam("file") MultipartFile file);

    /**
     * 根据发货通知单号，创建发货结果单
     *
     * @param relevanceNo 发货通知单号
     * @param preOrderNo  前置单号
     * @return 发货结果单id
     */
    @GetMapping(value = "/createDeliveryResultOrder", produces = "application/json")
    @ApiOperation(value = "根据发货通知单号，创建发货结果单", notes = "根据发货通知单号，创建发货结果单")
    RestResponse<Long> createDeliveryResultOrder(@RequestParam("relevanceNo") String relevanceNo,
                                                 @RequestParam("preOrderNo") String preOrderNo);

    @PostMapping(value = "/updateExtension", produces = "application/json")
    @ApiOperation(value = "更新收发货结果信息", notes = "更新收发货结果信息")
    RestResponse<Void> updateExtension(@RequestBody CsDeliveryResultOrderUpdateReqDto reqDto);


}