/**
 * @(#)CsDeliveryResultOrderQueryApi.java 1.0 2021/12/29 11:08
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsDeliveryResultOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryTotalCartonsRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * CsDeliveryResultOrderQueryApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:08
 * @since 1.0.0
 */
@Api(tags = {"CsDeliveryResultOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csDeliveryResultOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsDeliveryResultOrderQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询发货结果单详情信息", notes = "根据id查询发货结果单详情信息")
    RestResponse<CsDeliveryResultOrderRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 根据id查询根据单据号查询详情信息
     *
     * @param documentNo
     * @return
     */
    @GetMapping(value = "/{documentNo}/queryByDocumentNo", produces = "application/json")
    @ApiOperation(value = "根据单据号查询详情", notes = "根据单据号查询详情")
    RestResponse<CsDeliveryResultOrderRespDto> queryByDocumentNo(@PathVariable("documentNo") String documentNo);

    @GetMapping(value = "/{preOrderNo}/queryByPreOrderNo", produces = "application/json")
    @ApiOperation(value = "根据前置单据号查询详情", notes = "根据前置单据号查询详情")
    RestResponse<CsDeliveryResultOrderRespDto> queryByPreOrderNo(@PathVariable("preOrderNo") String preOrderNo);

    /**
     * 根据单据号查询二期详情
     *
     * @param documentNo
     * @return
     */
    @GetMapping(value = "/{documentNo}/queryByDocumentNo/versionSecond", produces = "application/json")
    @ApiOperation(value = "根据单据号查询二期详情", notes = "根据单据号查询二期详情")
    RestResponse<CsDeliveryResultOrderRespDto> queryVersionSecondByDocumentNo(@PathVariable("documentNo") String documentNo);

    /**
     * 根据单据号查询商品详情分页
     *
     * @param dto
     * @return
     */
    @PostMapping(value = "/detail/page", produces = "application/json")
    @ApiOperation(value = "根据单据号查询商品详情分页", notes = "根据单据号查询商品详情分页")
    RestResponse<PageInfo<CsDeliveryResultOrderDetailRespDto>> queryDeliveryResultOrderDetails(@Validated @RequestBody CsDeliveryResultOrderQueryDto dto);

    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询发货结果单", notes = "分页查询发货结果单")
    RestResponse<PageInfo<CsDeliveryResultOrderRespDto>> queryByPage(@Validated @RequestBody CsDeliveryResultOrderQueryDto queryDto);

    /**
     * 参数查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询", notes = "参数查询")
    RestResponse<List<CsDeliveryResultOrderRespDto>> queryByParam(@Validated @RequestBody CsDeliveryResultOrderQueryDto queryDto);

    @PostMapping(value = "/exportExcel", produces = "application/json")
    @ApiOperation(value = "导出发货结果单", notes = "导出发货结果单")
    RestResponse<Object> exportExcel( @RequestBody CsDeliveryResultOrderQueryDto queryDto);

    /**
     * 根据订单号查询发货结果单列表
     *
     * @param orderNo
     * @return
     */
    @GetMapping(value = "/{orderNo}/queryByOrderNo", produces = "application/json")
    @ApiOperation(value = "根据订单号查询发货结果单列表", notes = "根据订单号查询发货结果单列表")
    RestResponse<List<CsDeliveryResultOrderRespDto>> queryByOrderNo(@PathVariable("orderNo") String orderNo);

    /**
     * 根据订单号查询收货结果单关联的总箱数、拼箱数信息
     *
     * @param orderNo
     * @return
     */
    @GetMapping(value = "/{orderNo}/queryTotalCartons", produces = "application/json")
    @ApiOperation(value = "根据订单号查询收货结果单关联的总箱数、拼箱数信息", notes = "根据订单号查询收货结果单关联的总箱数、拼箱数信息")
    RestResponse<CsDeliveryTotalCartonsRespDto> queryTotalCartons(@PathVariable("orderNo") String orderNo);

    /**
     * 查询收发货货结果单信息及明细
     * @param queryDto 请求参数
     * @return 处理结果
     */
    @PostMapping(value = "/queryDeliveryReceiveResultDetail", produces = "application/json")
    @ApiOperation(value = "根据订单号查询收货结果单关联的总箱数、拼箱数信息", notes = "根据订单号查询收货结果单关联的总箱数、拼箱数信息")
    RestResponse<CsDeliveryReceiveResultRespDto> queryDeliveryReceiveResultDetail(@RequestBody CsDeliveryResultOrderQueryDto queryDto);
}