/**
 * @(#)CsInNoticeOrderQueryApi.java 1.0 2021/12/29 11:10
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInNoticeOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInNoticeOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* CsInNoticeOrderQueryApi
*
* @author jingran
* @Date: 2021/12/29 11:10
* @since 1.0.0
*/
@Api(tags = {"CsInNoticeOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInNoticeOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInNoticeOrderQueryApi {

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsInNoticeOrderRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsInNoticeOrderRespDto>> queryByPage(@Validated @RequestBody CsInNoticeOrderQueryDto queryDto);

    /**
     * 参数查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询", notes = "参数查询")
    RestResponse<List<CsInNoticeOrderRespDto>> queryByParam(@Validated @RequestBody CsInNoticeOrderQueryDto queryDto);

    /**
     * 根据单号查询根据单据号查询详情信息
     *
     * @param documentNo
     * @return
     */
    @GetMapping(value = "/{documentNo}/queryByDocumentNo", produces = "application/json")
    @ApiOperation(value = "根据单据号查询详情", notes = "根据单据号查询详情")
    RestResponse<CsInNoticeOrderRespDto> queryByDocumentNo(@PathVariable("documentNo") String documentNo);

    /**
     * 分页查询商品详情
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/detail/page", produces = "application/json")
    @ApiOperation(value = "分页查询商品详情", notes = "分页查询商品详情")
    RestResponse<PageInfo<CsInNoticeOrderDetailRespDto>> queryDetailByPage(@Validated @RequestBody CsInNoticeOrderDetailQueryDto queryDto);

}