/**
 * @(#)CsInResultOrderApi.java 1.0 2021/12/29 11:10
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInResultOrderUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * CsInResultOrderApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:10
 * @since 1.0.0
 */
@Api(tags = {"CsInResultOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csInResultOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInResultOrderApi {

    /**
     * 添加
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "/add", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsInResultOrderAddReqDto addReqDto);

    /**
     * 修改
     *
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsInResultOrderUpdateReqDto updateReqDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    /**
     * 营销云回传退货结果，生成入库结果单(待入库)，通知订单复审
     *
     * @param reqDto 收货明细
     * @return 入库结果单id
     */
    @PostMapping(value = "/refundResultBack", produces = "application/json")
    @ApiOperation(value = "营销云回传退货结果，生成入库结果单(待入库)", notes = "营销云回传退货结果，生成入库结果单(待入库)")
    RestResponse<Long> refundResultBack(@Validated @RequestBody TcbjResGenReqDto reqDto);


}