/**
 * @(#)CsOutNoticeOrderQueryApi.java 1.0 2021/12/29 11:12
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderDetailInfoQueryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutNoticeOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.QueryInTransitQualifiedNoticeReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.OutNoticeOrderDetailRespVo;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * CsOutNoticeOrderQueryApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:12
 * @since 1.0.0
 */
@Api(tags = {"CsOutNoticeOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csOutNoticeOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsOutNoticeOrderQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsOutNoticeOrderRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 根据单号查询根据单据号查询详情信息
     *
     * @param documentNo
     * @return
     */
    @GetMapping(value = "/{documentNo}/queryByDocumentNo", produces = "application/json")
    @ApiOperation(value = "根据单据号查询详情", notes = "根据单据号查询详情")
    RestResponse<CsOutNoticeOrderRespDto> queryByDocumentNo(@PathVariable("documentNo") String documentNo);

    /**
     * 分页查询详情
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/detail/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsOutNoticeOrderDetailRespDto>> queryDetailByPage(@Validated @RequestBody CsOutNoticeOrderQueryDto queryDto);

    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsOutNoticeOrderRespDto>> queryByPage(@Validated @RequestBody CsOutNoticeOrderQueryDto queryDto);

    /**
     * 参数查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询", notes = "参数查询")
    RestResponse<List<CsOutNoticeOrderRespDto>> queryByParam(@Validated @RequestBody CsOutNoticeOrderQueryDto queryDto);


    /**
     * 商品详情信息分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/detail/groupingPage", produces = "application/json")
    @ApiOperation(value = "商品详情信息分页查询", notes = "商品详情信息分页查询")
    RestResponse<PageInfo<CsOutNoticeOrderDetailRespDto>> groupingPage(@Validated @RequestBody CsOutNoticeOrderDetailInfoQueryReqDto queryDto);


    /**
     * 加载在途转合格相关出库通知单
     *
     * @return 出库结果单分页数据
     */
    @PostMapping("/queryInTransitQualifiedNotice")
    @ApiOperation(value = "加载在途转合格相关出库通知单", notes = "加载在途转合格相关出库通知单")
    RestResponse<PageInfo<OutNoticeOrderDetailRespVo>> queryInTransitQualifiedNotice(@RequestBody QueryInTransitQualifiedNoticeReqDto reqDto);

    /**
     * 根据关联单号，查询出入库通知单主体信息
     *
     * @param relevanceNoList 关联单号集合
     * @return 出入库通知单主体信息
     */
    @PostMapping(value = "/queryByRelevanceNoList", produces = "application/json")
    @ApiOperation(value = "根据关联单号，查询出入库通知单主体信息", notes = "根据关联单号，查询出入库通知单主体信息")
    RestResponse<List<CsOutNoticeOrderRespDto>> queryByRelevanceNoList(@RequestBody List<String> relevanceNoList);

}