/**
 * @(#)CsOutResultOrderApi.java 1.0 2021/12/29 11:13
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.base.req.TcbjResGenReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOutResultOrderRepairDataDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderStringValidReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * CsOutResultOrderApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:13
 * @since 1.0.0
 */
@Api(tags = {"CsOutResultOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csOutResultOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsOutResultOrderApi {

    /**
     * 添加
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsOutResultOrderAddReqDto addReqDto);

    /**
     * 修改
     *
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsOutResultOrderUpdateReqDto updateReqDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);


    @PostMapping(value = "/sendBack", produces = "application/json")
    @ApiOperation(value = "营销云 发货回传;生成发货结果单", notes = "发货回传")
    RestResponse<String> sendBack(@Validated @RequestBody TcbjResGenReqDto reqDto);

    /**
     * wms发货回传
     *
     * @param csOutResultOrderAddReqDto
     * @return
     */
    @PostMapping(value = "/wmsSendBack", produces = "application/json")
    @ApiOperation(value = "wms发货回传", notes = "wms发货回传")
    RestResponse<String> wmsSendBack(@Validated @RequestBody CsOutResultOrderAddReqDto csOutResultOrderAddReqDto);


    /**
     * 更新出库结果单串码校验参数
     *
     * @param stringValidReqDtoList
     * @return
     */
    @PostMapping(value = "/updateStringValidResult", produces = "application/json")
    @ApiOperation(value = "更新出库结果单串码校验参数", notes = "更新出库结果单串码校验参数")
    RestResponse<Void> updateStringValidResult(@RequestBody List<CsOutResultOrderStringValidReqDto> stringValidReqDtoList);


    /**
     * 数据修正
     */
    @PostMapping(value = "/repairData/{documentNo}", produces = "application/json")
    @ApiOperation(value = "数据修正", notes = "数据修正")
    RestResponse<Void> repairData (@PathVariable("documentNo") String documentNo, @RequestBody List<CsOutResultOrderRepairDataDto> repairDataDtos);

    /**
     * 结果单解挂
     */
    @PostMapping(value = "/unhook/{documentNo}", produces = "application/json")
    @ApiOperation(value = "结果单解挂", notes = "结果单解挂")
    RestResponse<Void> unhook (@PathVariable("documentNo") String documentNo, @RequestParam(name = "remark", required = false) String remark);

}