/**
 * @(#)CsReceiveNoticeOrderQueryApi.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveNoticeOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsReceiveNoticeOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsReceiveNoticeOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* CsReceiveNoticeOrderQueryApi
*
* @author jingran
* @Date: 2021/12/29 11:15
* @since 1.0.0
*/
@Api(tags = {"收货通知单接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csReceiveNoticeOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsReceiveNoticeOrderQueryApi {

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询收货通知详情", notes = "根据id查询收货通知详情")
    RestResponse<CsReceiveNoticeOrderRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    @GetMapping(value = "/{documentNo}/queryByDocumentNo", produces = "application/json")
    @ApiOperation(value = "根据单据号查询详情", notes = "根据单据号查询详情")
    RestResponse<CsReceiveNoticeOrderRespDto> queryByDocumentNo(@PathVariable("documentNo") String documentNo);

    @GetMapping(value = "/{documentNo}/queryByDocumentNo/versionSecond", produces = "application/json")
    @ApiOperation(value = "根据单据号查询二期详情", notes = "根据单据号查询二期详情")
    RestResponse<CsReceiveNoticeOrderRespDto> queryVersionSecondByDocumentNo(@PathVariable("documentNo") String documentNo);

    /**
     * 分页查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询收货通知单", notes = "分页查询收货通知单")
    RestResponse<PageInfo<CsReceiveNoticeOrderRespDto>> queryByPage(@Validated @RequestBody CsReceiveNoticeOrderQueryDto queryDto);

    /**
     * 参数查询
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询", notes = "参数查询")
    RestResponse<List<CsReceiveNoticeOrderRespDto>> queryByParam(@Validated @RequestBody CsReceiveNoticeOrderQueryDto queryDto);

    /**
     * 根据单据号查询商品详情分页
     *
     * @param dto
     * @return
     */
    @PostMapping(value = "/detail/page", produces = "application/json")
    @ApiOperation(value = "根据单据号查询商品详情分页", notes = "根据单据号查询商品详情分页")
    RestResponse<PageInfo<CsReceiveNoticeOrderDetailRespDto>> queryReceiveNoticeOrderDetails(@Validated @RequestBody CsReceiveNoticeOrderDetailQueryDto dto);
}