/**
 * @(#)CsReceiveResultOrderQueryApi.java 1.0 2021/12/29 11:16
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsReceiveResultOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsReceiveResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsReceiveResultOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * CsReceiveResultOrderQueryApi
 *
 * @author jingran
 * @Date: 2021/12/29 11:16
 * @since 1.0.0
 */
@Api(tags = {"CsReceiveResultOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csReceiveResultOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsReceiveResultOrderQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询收货结果单详情", notes = "根据id查询收货结果单详情")
    RestResponse<CsReceiveResultOrderRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询收货结果单", notes = "分页查询收货结果单")
    RestResponse<PageInfo<CsReceiveResultOrderRespDto>> queryByPage(@Validated @RequestBody CsReceiveResultOrderQueryDto queryDto);

    /**
     * 参数查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询", notes = "参数查询")
    RestResponse<List<CsReceiveResultOrderRespDto>> queryByParam(@Validated @RequestBody CsReceiveResultOrderQueryDto queryDto);

    @GetMapping(value = "/{documentNo}/queryByDocumentNo", produces = "application/json")
    @ApiOperation(value = "根据单据号查询详情", notes = "根据单据号查询详情")
    RestResponse<CsReceiveResultOrderRespDto> queryByDocumentNo(@PathVariable("documentNo") String documentNo);

    @GetMapping(value = "/{documentNo}/queryByDocumentNo/versionSecond", produces = "application/json")
    @ApiOperation(value = "根据单据号查询二期详情", notes = "根据单据号查询二期详情")
    RestResponse<CsReceiveResultOrderRespDto> queryVersionSecondByDocumentNo(@PathVariable("documentNo") String documentNo);

    @PostMapping(value = "/exportExcel", produces = "application/json")
    @ApiOperation(value = "导出收货结果单", notes = "导出收货结果单")
    RestResponse<Object> exportExcel(@RequestBody CsReceiveResultOrderQueryDto queryDto);

    /**
     * 根据单据号查询商品详情分页
     *
     * @param dto
     * @return
     */
    @PostMapping(value = "/detail/page", produces = "application/json")
    @ApiOperation(value = "根据单据号查询商品详情分页", notes = "根据单据号查询商品详情分页")
    RestResponse<PageInfo<CsReceiveResultOrderDetailRespDto>> queryReceiveResultOrderDetails(@Validated @RequestBody CsReceiveResultOrderDetailQueryDto dto);

}