/**
 * @(#)CsBatchAdjustmentOrderApi.java 1.0 2022/04/19 17:21
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsBatchAdjustmentOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsBatchAdjustmentOrderGenerateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * CsBatchAdjustmentOrderApi
 *
 * @author jingran
 * @Date: 2022/04/19 17:21
 * @since 1.0.0
 */
@Api(tags = {"CsBatchAdjustmentOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csBatchAdjustmentOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsBatchAdjustmentOrderApi {

    /**
     * 详情页中根据状态新增、提交批次调整单
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "/generateBatchAdjustmentOrder", produces = "application/json")
    @ApiOperation(value = "详情页中根据状态新增、提交批次调整单")
    RestResponse<Long> generateBatchAdjustmentOrder(@Validated @RequestBody CsBatchAdjustmentOrderGenerateReqDto addReqDto);

    /**
     * 编辑批次调整单
     * @param orderNo
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{orderNo}/editBatchAdjustmentOrder", produces = "application/json")
    @ApiOperation(value = "编辑批次调整单")
    RestResponse<Void> editBatchAdjustmentOrder(@PathVariable(name = "orderNo") String orderNo, @RequestBody CsBatchAdjustmentOrderGenerateReqDto updateReqDto);

    /**
     * 列表中提交批次调整单
     *
     * @param orderNo
     * @return
     */
    @PostMapping(value = "/{orderNo}/submitBatchAdjustmentOrder", produces = "application/json")
    @ApiOperation(value = "提交批次调整单", notes = "提交批次调整单")
    RestResponse<Void> submitBatchAdjustmentOrder(@PathVariable(name = "orderNo") String orderNo);

    /**
     * 审核批次调整单
     *
     * @param auditReqDto
     * @return
     */
    @PostMapping(value = "/auditBatchAdjustmentOrder", produces = "application/json")
    @ApiOperation(value = "审核批次调整单", notes = "审核批次调整单")
    RestResponse<Void> auditBatchAdjustmentOrder(@RequestBody CsBatchAdjustmentOrderAuditReqDto auditReqDto);

    /**
     * 根据批次调整单号取消
     *
     * @param orderNo
     * @return
     */
    @PostMapping(value = "/{orderNo}/cancelByOrderNo", produces = "application/json")
    @ApiOperation(value = "根据批次调整单号取消", notes = "根据批次调整单号取消")
    RestResponse<Void> cancelByOrderNo(@PathVariable(name = "orderNo") String orderNo);
}