/**
 * @(#)CsBatchAdjustmentOrderDetailQueryApi.java 1.0 2022/04/19 17:21
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsBatchAdjustmentOrderDetailQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsBatchAdjustmentOrderDetailRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * CsBatchAdjustmentOrderDetailQueryApi
 *
 * @author jingran
 * @Date: 2022/04/19 17:21
 * @since 1.0.0
 */
@Api(tags = {"CsBatchAdjustmentOrderDetail接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csBatchAdjustmentOrderDetail", url = "${yundt.cube.center.inventory.api:}")
public interface ICsBatchAdjustmentOrderDetailQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsBatchAdjustmentOrderDetailRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询单据商品详情信息
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryItemDetailPageInfo", produces = "application/json")
    @ApiOperation(value = "分页查询单据商品详情信息", notes = "分页查询单据商品详情信息")
    RestResponse<PageInfo<CsBatchAdjustmentOrderDetailRespDto>> queryItemDetailPageInfo(@RequestBody CsBatchAdjustmentOrderDetailQueryDto queryDto);

    /**
     * 分页查询单据商品详情信息并返回可变更数量
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryItemDetailPageInfoAndAvailable", produces = "application/json")
    @ApiOperation(value = "分页查询单据商品详情信息并返回可变更数量", notes = "分页查询单据商品详情信息并返回可变更数量")
    RestResponse<PageInfo<CsBatchAdjustmentOrderDetailRespDto>> queryItemDetailPageInfoAndAvailable(@RequestBody CsBatchAdjustmentOrderDetailQueryDto queryDto);

}