/**
 * @(#)CsBatchAdjustmentOrderQueryApi.java 1.0 2022/04/19 17:21
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsBatchAdjustmentOrderRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * CsBatchAdjustmentOrderQueryApi
 *
 * @author jingran
 * @Date: 2022/04/19 17:21
 * @since 1.0.0
 */
@Api(tags = {"CsBatchAdjustmentOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csBatchAdjustmentOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsBatchAdjustmentOrderQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsBatchAdjustmentOrderRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 根据单据编码查询单据详情信息
     *
     * @param orderNo
     * @return
     */
    @PostMapping(value = "/{orderNo}/queryDetailByOrderNo", produces = "application/json")
    @ApiOperation(value = "根据单据编码查询单据详情信息", notes = "根据单据编码查询单据详情信息")
    RestResponse<CsBatchAdjustmentOrderRespDto> queryDetailByOrderNo(@PathVariable(name = "orderNo") String orderNo);

}