/**
 * @(#)CsInPlannedOrderQueryApi.java 1.0 2022/04/13 15:39
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* CsInPlannedOrderQueryApi
*
* @author jingran
* @Date: 2022/04/13 15:39
* @since 1.0.0
*/
@Api(tags = {"CsInPlannedOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}", path = "/v1/csInPlannedOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInPlannedOrderQueryApi {

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsInPlannedOrderRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     *
     * @param inPlannedOrderPageQueryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsInPlannedOrderRespDto>> queryByPage(@Validated @RequestBody CsInPlannedOrderPageQueryDto inPlannedOrderPageQueryDto);

    /**
     * 根据单据编码查询单据详情信息
     *
     * @param orderNo  单据编号
     * @return
     */
    @GetMapping(value = "/{orderNo}/queryDetailByOrderNo", produces = "application/json")
    @ApiOperation(value = "根据单据编码查询单据详情信息", notes = "根据单据编码查询单据详情信息")
    RestResponse<CsInPlannedOrderDetailQueryInfoRespDto> queryDetailByOrderNo(@PathVariable("orderNo") String orderNo);

    /**
     * 根据入库结果单单号查询超收信息
     *
     * @param receiveDocumentNo  入库结果单单号
     * @return
     */
    @GetMapping(value = "/{receiveDocumentNo}/queryOverchargeDetailByDocumentNo", produces = "application/json")
    @ApiOperation(value = "根据入库结果单单号查询超收信息", notes = "根据入库结果单单号查询超收信息")
    RestResponse<List<CsInResultOrderDetailRespDto>> queryOverchargeDetailByDocumentNo(@PathVariable("receiveDocumentNo") String receiveDocumentNo);

    /**
     * 根据主健查询
     */
    @PostMapping(value = "/queryByIds", produces = "application/json")
    @ApiOperation(value = "根据主健查询", notes = "根据主健查询")
    RestResponse<List<CsInPlannedOrderRespDto>> queryByIds(@RequestBody List<Long> ids);


}