/**
 * @(#)CsOutPlannedOrderApi.java 1.0 2022/04/13 16:40
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.*;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderResultRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
* CsOutPlannedOrderApi
*
* @author jingran
* @Date: 2022/04/13 16:40
* @since 1.0.0
*/
@Api(tags = {"CsOutPlannedOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csOutPlannedOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsOutPlannedOrderApi {

    /**
     * 添加
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsOutPlannedOrderAddReqDto addReqDto);

    /**
     * 修改
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsOutPlannedOrderUpdateReqDto updateReqDto);

    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);


    /**
     * 生成退货订单单据（采购、委外）
     *
     * @param plannedOrderGenerateReqDto
     * @return
     */
    @PostMapping(value = "/generateRetreatOrder", produces = "application/json")
    @ApiOperation(value = "生成退货订单单据", notes = "生成退货订单单据")
    RestResponse<Long> generateRetreatOrder(@RequestBody CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto);

    /**
     * 审核单据
     *
     * @param plannedOrderAuditReqDto
     * @return
     */
    @PostMapping(value = "/auditRetreatOrder", produces = "application/json")
    @ApiOperation(value = "审核退货单据", notes = "审核退货单据")
    RestResponse<CsOutPlannedOrderResultRespDto> auditRetreatOrder(@RequestBody CsOutPlannedOrderAuditReqDto plannedOrderAuditReqDto);

    /**
     * 根据单据号关闭计划单据
     * 在计划单列表的关闭操作，在单据给到WSM之前，都是可以进行关闭的，如果单据给了
     * WSM之后，就不能进行关闭了
     *
     * @param orderNo  单据编号
     * @return
     */
    @GetMapping(value = "/{orderNo}/cancelByOrderNo", produces = "application/json")
    @ApiOperation(value = "根据单据号关闭计划单据", notes = "根据单据号关闭计划单据")
    RestResponse<Void> cancelByOrderNo(@PathVariable("orderNo") String orderNo);

    /**
     * 退货单据编辑重新提交
     *
     * @param plannedOrderGenerateReqDto
     * @return
     */
    @PostMapping(value = "/editRetreatOrder", produces = "application/json")
    @ApiOperation(value = "退货单据编辑重新提交", notes = "退货单据编辑重新提交")
    RestResponse<Long> editRetreatOrder(@RequestBody CsOutPlannedOrderGenerateReqDto plannedOrderGenerateReqDto);

    /**
     * 根据单据号提交计划单据，将计划单据由"待提交"转为"待审核"
     *
     * @param orderNo  单据编号
     * @return
     */
    @GetMapping(value = "/{orderNo}/submitByOrderNo", produces = "application/json")
    @ApiOperation(value = "根据单据号提交计划单据", notes = "根据单据号提交计划单据")
    RestResponse<Void> submitByOrderNo(@PathVariable("orderNo") String orderNo);

    /**
     * 根据出库结果单单号解挂出库结果单
     *
     * @param outPlannedRelieveDifferenceReqDto  出库结果单单号
     * @return
     */
    @PostMapping(value = "/relieveDifferenceByOrderDocumentNo", produces = "application/json")
    @ApiOperation(value = "根据入库结果单单号解挂入库结果单", notes = "根据入库结果单单号解挂入库结果单")
    RestResponse<Void> relieveDifferenceByOrderDocumentNo(@RequestBody CsOutPlannedRelieveDifferenceReqDto outPlannedRelieveDifferenceReqDto);

    /**
     * 超发差异数据调整保存提交
     *
     * @param differenceAdjustReqDto  请求参数
     * @return
     */
    @PostMapping(value = "/differenceAdjust", produces = "application/json")
    @ApiOperation(value = "超发差异数据调整保存提交", notes = "超发差异数据调整保存提交")
    RestResponse<Void> differenceAdjust(@Validated @RequestBody CsOutPlannedDifferenceAdjustReqDto differenceAdjustReqDto);

}