/**
 * @(#)CsOutPlannedOrderQueryApi.java 1.0 2022/04/13 16:40
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.order.pcp;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.in.CsInPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.out.CsOutPlannedOrderPageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsInResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutResultOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.in.CsInPlannedOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderDetailQueryInfoRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.out.CsOutPlannedOrderRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * CsOutPlannedOrderQueryApi
 *
 * @author jingran
 * @Date: 2022/04/13 16:40
 * @since 1.0.0
 */
@Api(tags = {"CsOutPlannedOrder接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csOutPlannedOrder", url = "${yundt.cube.center.inventory.api:}")
public interface ICsOutPlannedOrderQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsOutPlannedOrderRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     *
     * @param outPlannedOrderPageQueryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsOutPlannedOrderRespDto>> queryByPage(@RequestBody CsOutPlannedOrderPageQueryDto outPlannedOrderPageQueryDto);

    /**
     * 根据单据编码查询单据详情信息
     *
     * @param orderNo 单据编号
     * @return
     */
    @PostMapping(value = "/queryDetailByOrderNo", produces = "application/json")
    @ApiOperation(value = "根据单据编码查询单据详情信息", notes = "根据单据编码查询单据详情信息")
    RestResponse<CsOutPlannedOrderDetailQueryInfoRespDto> queryDetailByOrderNo(@RequestParam("orderNo") String orderNo);

    /**
     * 根据出库结果单单号查询超发信息
     *
     * @param resultDocumentNo 出库结果单单号
     * @return
     */
    @GetMapping(value = "/queryDifferenceDetailByDocumentNo", produces = "application/json")
    @ApiOperation(value = "根据出库结果单单号查询超发信息", notes = "根据出库结果单单号查询超发信息")
    RestResponse<List<CsOutResultOrderDetailRespDto>> queryDifferenceDetailByDocumentNo(@RequestParam("deliveryDocumentNo") String resultDocumentNo);

    /**
     * 根据id查询
     * @param ids
     * @return
     */
    @PostMapping(value = "/queryByIds", produces = "application/json")
    @ApiOperation(value = "根据主健查询", notes = "根据主健查询")
    RestResponse<List<CsOutPlannedOrderRespDto>> queryByIds(@RequestBody List<Long> ids);

}