package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventorySupplierReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 供应商资料表服务接口
*
* @author yuangui
* @since 2022-04-12
*/
@Api(tags = {"供应商资料表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsInventorySupplierApi",
    name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
    path = "/v1/csInventorySupplier",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsInventorySupplierApi {

    /**
    * 新增供应商资料表
    *
    * @param addReqDto 供应商资料表请求对象
    * @return 处理结果
    */
    @PostMapping("/saveCustomer")
    @ApiOperation(value = "新增供应商资料表", notes = "新增供应商资料表")
    RestResponse<Long> addCsInventorySupplier(@RequestBody CsInventorySupplierReqDto addReqDto);

    /**
    * 修改供应商资料表
    *
    * @param modifyReqDto 供应商资料表请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改供应商资料表", notes = "修改供应商资料表")
    RestResponse<Void> modifyCsInventorySupplier(@RequestBody CsInventorySupplierReqDto modifyReqDto);

    /**
    * 删除供应商资料表
    *
    * @param ids        供应商资料表删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除供应商资料表", notes = "删除供应商资料表")
    RestResponse<Void> removeCsInventorySupplier(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
