package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventorySupplierReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsInventorySupplierRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 供应商资料表服务接口
*
* @author yuangui
* @since 2022-04-12
*/
@Api(tags = {"供应商资料表服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-query-ICsInventorySupplierQueryApi",
    name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
    path = "/v1/csInventorySupplier",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsInventorySupplierQueryApi {

    /**
    * 根据id查询供应商资料表
    *
    * @param id 供应商资料表id
    * @return   供应商资料表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询供应商资料表", notes = "根据id查询供应商资料表")
    RestResponse<CsInventorySupplierRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 供应商资料表分页数据
    *
    * @param filter   供应商资料表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 供应商资料表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "供应商资料表分页数据", notes = "根据filter查询条件查询供应商资料表数据，filter=CsInventorySupplierReqDto")
    RestResponse<PageInfo<CsInventorySupplierRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    /**
     * 根据参数查询
     *
     * @param csInventorySupplierReqDto 请求DTO
     * @return
     */
    @PostMapping(value = "/queryParam", produces = "application/json")
    @ApiOperation(value = "根据参数查询", notes = "根据参数查询")
    RestResponse<List<CsInventorySupplierRespDto>> queryParam(@RequestBody CsInventorySupplierReqDto csInventorySupplierReqDto);


}
