/**
 * @(#)CsInventoryWarningApi.java 1.0 2022/06/13 17:01
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventoryWarningAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventoryWarningUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
* CsInventoryWarningApi
*
* @author jingran
* @Date: 2022/06/13 17:01
* @since 1.0.0
*/
@Api(tags = {"CsInventoryWarning接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:cis-yundt-cube-center-inventory}", path = "/v1/csInventoryWarning", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInventoryWarningApi {

    /**
     * 添加
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsInventoryWarningAddReqDto addReqDto);

    /**
     * 修改
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsInventoryWarningUpdateReqDto updateReqDto);

    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

    /**
     * 批量插入
     *
     * @param addReqDtoList
     * @return
     */
    @PostMapping(value = "/batchInsert", produces = "application/json")
    @ApiOperation(value = "批量插入", notes = "批量插入")
    RestResponse<Boolean> batchInsert(@Validated @RequestBody List<CsInventoryWarningAddReqDto> addReqDtoList);

}