/**
 * @(#)CsInventoryWarningQueryApi.java 1.0 2022/06/13 17:01
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsInventoryWarningQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsInventoryWarningRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
* CsInventoryWarningQueryApi
*
* @author jingran
* @Date: 2022/06/13 17:01
* @since 1.0.0
*/
@Api(tags = {"CsInventoryWarning接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:cis-yundt-cube-center-inventory}", path = "/v1/csInventoryWarning", url = "${yundt.cube.center.inventory.api:}")
public interface ICsInventoryWarningQueryApi {

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsInventoryWarningRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     *
     * @param csInventoryWarningQueryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsInventoryWarningRespDto>> queryByPage(@Validated @RequestBody CsInventoryWarningQueryDto csInventoryWarningQueryDto);

    /**
     * 实物/虚拟仓库存预警设置分页查询
     *
     * @param csInventoryWarningQueryDto
     * @return
     */
    @PostMapping(value = "/warningSettingPage", produces = "application/json")
    @ApiOperation(value = "实物/虚拟仓库存预警设置分页查询", notes = "实物/虚拟仓库存预警设置分页查询")
    RestResponse<PageInfo<CsInventoryWarningRespDto>> warningSettingPage(@Validated @RequestBody CsInventoryWarningQueryDto csInventoryWarningQueryDto);


}