/**
 * @(#)CsPlannedOrderAuditApi.java 1.0 2022/04/13 15:43
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsPlannedOrderAuditAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsPlannedOrderAuditUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;

/**
* CsPlannedOrderAuditApi
*
* @author jingran
* @Date: 2022/04/13 15:43
* @since 1.0.0
*/
@Api(tags = {"CsPlannedOrderAudit接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csPlannedOrderAudit", url = "${yundt.cube.center.inventory.api:}")
public interface ICsPlannedOrderAuditApi {

    /**
     * 添加
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsPlannedOrderAuditAddReqDto addReqDto);

    /**
     * 修改
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsPlannedOrderAuditUpdateReqDto updateReqDto);

    /**
     * 删除
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

}