/**
 * @(#)CsVirtualInventoryApi.java 1.0 2022/06/17 14:45
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsVirtualInventoryAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsVirtualInventoryUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * CsVirtualInventoryApi
 *
 * @author jingran
 * @Date: 2022/06/17 14:45
 * @since 1.0.0
 */
@Api(tags = {"CsVirtualInventory接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:cis-yundt-cube-center-inventory}", path = "/v1/csVirtualInventory", url = "${yundt.cube.center.inventory.api:}")
public interface ICsVirtualInventoryApi {

    /**
     * 添加
     *
     * @param addReqDto
     * @return
     */
    @PostMapping(value = "", produces = "application/json")
    @ApiOperation(value = "添加", notes = "添加")
    RestResponse<Long> add(@Validated @RequestBody CsVirtualInventoryAddReqDto addReqDto);

    /**
     * 修改
     *
     * @param id
     * @param updateReqDto
     * @return
     */
    @PostMapping(value = "/{id}/update", produces = "application/json")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> update(@PathVariable("id") Long id, @Validated @RequestBody CsVirtualInventoryUpdateReqDto updateReqDto);

    /**
     * 删除
     *
     * @param id
     * @return
     */
    @PostMapping(value = "/{id}/delete", produces = "application/json")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> delete(@PathVariable("id") Long id);

}