/**
 * @(#)CsVirtualInventoryQueryApi.java 1.0 2022/06/17 14:45
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsVirtualInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsVirtualInventoryRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * CsVirtualInventoryQueryApi
 *
 * @author jingran
 * @Date: 2022/06/17 14:45
 * @since 1.0.0
 */
@Api(tags = {"CsVirtualInventory接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:cis-yundt-cube-center-inventory}", path = "/v1/csVirtualInventory", url = "${yundt.cube.center.inventory.api:}")
public interface ICsVirtualInventoryQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsVirtualInventoryRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

}