package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsProduceOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsProduceOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsPurchaseOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsPurchaseOrderReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @description:
 * @projectName:yundt-cube-center-inventory
 * @see:com.dtyunxi.yundt.cube.center.inventory.api.cs.other
 * @author:初见
 * @createTime:2022/3/31 14:49
 */

@Api(tags = {"生产订单接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csProduceOrder", url = "${yundt.cube.center.inventory.api:}")
public interface IcsProduceOrderQueryApi {
    /**
     * 生产入库订单新增处理
     * @param produceOrderReqDto
     * @return
     */
    @PostMapping(value = "/produceOrderAdd", produces = "application/json")
    @ApiOperation(value = "生产入库订单新增处理", notes = "生产入库")
    RestResponse<Long> produceOrderAdd(@Validated @RequestBody CsProduceOrderReqDto produceOrderReqDto);

    /**
     * 生产入库订单取消处理
     * @param produceOrderCancelDto
     * @return
     */
    @PostMapping(value = "/produceOrderCancel", produces = "application/json")
    @ApiOperation(value = "生产入库订单取消处理", notes = "生产取消")
    RestResponse<Long> produceOrderCancel(@Validated @RequestBody CsProduceOrderCancelReqDto produceOrderCancelDto);

}
