package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsPurchaseOrderCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsPurchaseOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @description:
 * @projectName:yundt-cube-center-inventory
 * @see:com.dtyunxi.yundt.cube.center.inventory.api.cs.other
 * @author:初见
 * @createTime:2022/3/31 14:49
 */

@Api(tags = {"采购入库接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csPurchaseOrder", url = "${yundt.cube.center.inventory.api:}")
public interface IcsPurchaseOrderQueryApi {
    /**
     * 采购入库订单新增处理
     * @param purchaseOrderAddDto
     * @return
     */
    @PostMapping(value = "/purchaseOrderAdd", produces = "application/json")
    @ApiOperation(value = "采购入库订单新增处理", notes = "采购入库")
    RestResponse<Long> purchaseOrderAdd(@Validated @RequestBody CsPurchaseOrderReqDto purchaseOrderAddDto);

    /**
     * 采购入库订单取消处理
     * @param purchaseOrderCancelDto
     * @return
     */
    @PostMapping(value = "/purchaseOrderCancel", produces = "application/json")
    @ApiOperation(value = "采购入库订单取消处理", notes = "采购取消")
    RestResponse<Long> purchaseOrderCancel(@Validated @RequestBody CsPurchaseOrderCancelReqDto purchaseOrderCancelDto);

}
