package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsPurchaseReturnCancelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsPurchaseReturnReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @description:
 * @projectName:yundt-cube-center-inventory
 * @see:com.dtyunxi.yundt.cube.center.inventory.api.cs.other
 * @author:初见
 * @createTime:2022/3/31 14:49
 */

@Api(tags = {"采购退货接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csPurchaseReturn", url = "${yundt.cube.center.inventory.api:}")
public interface IcsPurchaseReturnQueryApi {
    /**
     * 采购入库退货新增处理
     * @param purchaseReturnAddDto
     * @return
     */
    @PostMapping(value = "/purchaseReturnAdd", produces = "application/json")
    @ApiOperation(value = "采购入库订单新增处理", notes = "采购入库")
    RestResponse<Long> purchaseReturnAdd(@Validated @RequestBody CsPurchaseReturnReqDto purchaseReturnAddDto);

    /**
     * 采购入库退货取消处理
     * @param purchaseReturnCancelDto
     * @return
     */
    @PostMapping(value = "/purchaseReturnCancel", produces = "application/json")
    @ApiOperation(value = "采购入库订单取消处理", notes = "采购取消")
    RestResponse<Long> purchaseReturnCancel(@Validated @RequestBody CsPurchaseReturnCancelReqDto purchaseReturnCancelDto);

}
