/**
 * @(#)csShipmenetEnterpriseQueryApi.java 1.0 2022/03/15 10:38
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.other;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.other.CsShipmenetEnterpriseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOrderPreRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.other.CsShipmenetEnterpriseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
* csShipmenetEnterpriseQueryApi
*
* @author chujian
* @Date: 2022/03/15 10:38
* @since 1.0.0
*/
@Api(tags = {"csShipmenetEnterprise接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csShipmenetEnterprise", url = "${yundt.cube.center.inventory.api:}")
public interface IcsShipmenetEnterpriseQueryApi {

    /**
     * 根据id查询信息
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsShipmenetEnterpriseRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询（通用方法）
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询（通用方法）", notes = "分页查询")
    RestResponse<PageInfo<CsShipmenetEnterpriseRespDto>> queryByPage(@Validated @RequestBody CsShipmenetEnterpriseQueryDto queryDto);

    /**
     * 参数查询（通用方法）
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryByParam", produces = "application/json")
    @ApiOperation(value = "参数查询（通用方法）", notes = "参数查询")
    RestResponse<List<CsShipmenetEnterpriseRespDto>> queryByParam(@Validated @RequestBody CsShipmenetEnterpriseQueryDto queryDto);

    /**
     * 根据单据号查询各类单据号
     * @param orderNo
     * @return
     */
    @GetMapping(value = "/{orderNo}/handlePreDocumentInfoByOrderNo", produces = "application/json")
    @ApiOperation(value = "根据单据号查询各类单据号", notes = "根据单据号查询各类单据号")
    RestResponse<List<CsOrderPreRespDto>> handlePreDocumentInfoByOrderNo(@PathVariable("orderNo") String orderNo);
}