/**
 * @(#)CsChannelWarehouseQueryApi.java 1.0 2022/03/07 14:51
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsChannelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsChannelWarehouseShopAddQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PcpOrderChannelRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * CsChannelWarehouseQueryApi
 *
 * @author jingran
 * @Date: 2022/03/07 14:51
 * @since 1.0.0
 */
@Api(tags = {"CsChannelWarehouse接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v1/csChannelWarehouse", url = "${yundt.cube.center.inventory.api:}")
public interface ICsChannelWarehouseQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsChannelWarehouseRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 根据id查询根据仓库编码查询详情信息
     *
     * @param warehouseCode
     * @return
     */
    @GetMapping(value = "/{warehouseCode}/queryByWarehouseCode", produces = "application/json")
    @ApiOperation(value = "根据仓库编码查询详情", notes = "根据仓库编码查询详情")
    RestResponse<CsChannelWarehouseRespDto> queryByWarehouseCode(@PathVariable("warehouseCode") String warehouseCode);


    /**
     * 确定仓库编码是否可用
     *
     * @param warehouseCode
     * @return
     */
    @GetMapping(value = "/checkWarehouseCode", produces = "application/json")
    @ApiOperation(value = "确定仓库编码是否可用", notes = "确定仓库编码是否可用")
    RestResponse<Boolean> checkWarehouseCode(@RequestParam("warehouseCode") String warehouseCode);

    /**
     * 分页查询店铺列表
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/shop/page", produces = "application/json")
    @ApiOperation(value = "分页查询店铺列表", notes = "分页查询店铺列表")
    RestResponse<PageInfo<PcpOrderChannelRespDto>> queryShopByPage(@Validated @RequestBody CsChannelWarehouseQueryDto queryDto);

    /**
     * 分页新增查询店铺列表
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/shopAdd/page", produces = "application/json")
    @ApiOperation(value = "分页新增查询店铺列表", notes = "分页新增查询店铺列表")
    RestResponse<PageInfo<PcpOrderChannelRespDto>> queryShopAddByPage(@Validated @RequestBody CsChannelWarehouseShopAddQueryDto queryDto);


    /**
     * 分页查询逻辑仓列表
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/logicWarehouse/page", produces = "application/json")
    @ApiOperation(value = "分页查询逻辑仓列表", notes = "分页查询逻辑仓列表")
    RestResponse<PageInfo<CsLogicWarehouseRespDto>> queryLogicWarehouseByPage(@Validated @RequestBody CsChannelWarehouseQueryDto queryDto);

    /**
     * 分页新增查询逻辑仓列表
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/logicWarehouseAdd/page", produces = "application/json")
    @ApiOperation(value = "分页查询逻辑仓列表", notes = "分页查询逻辑仓列表")
    RestResponse<PageInfo<CsLogicWarehouseRespDto>> queryLogicWarehouseAddByPage(@Validated @RequestBody CsChannelWarehouseQueryDto queryDto);


    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsChannelWarehouseRespDto>> queryByPage(@Validated @RequestBody CsChannelWarehouseQueryDto queryDto);


    /**
     * 根据渠道仓编码以及逻辑仓ID删除关联关系
     *
     * @param warehouseCode
     * @return
     */
    @GetMapping(value = "/{warehouseCode}/{logicWarehouseId}/deleteRelLogicWarehouse", produces = "application/json")
    @ApiOperation(value = "根据渠道仓编码以及逻辑仓ID删除关联关系", notes = "根据渠道仓编码以及逻辑仓ID删除关联关系")
    RestResponse<Boolean> deleteRelLogicWare(@PathVariable("warehouseCode") String warehouseCode, @PathVariable("logicWarehouseId") String logicWarehouseId);

    /**
     * 根据渠道仓编码以及店铺渠道ID删除关联关系
     *
     * @param warehouseCode
     * @return
     */
    @GetMapping(value = "/{warehouseCode}/{channelId}/deleteRelShop", produces = "application/json")
    @ApiOperation(value = "根据渠道仓编码以及店铺渠道ID删除关联关系", notes = "根据渠道仓编码以及店铺渠道ID删除关联关系")
    RestResponse<Boolean> deleteRelShop(@PathVariable("warehouseCode") String warehouseCode, @PathVariable("channelId") Long channelId);

    /**
     * 批量根据渠道仓库编码查询渠道仓信息和关联的逻辑仓信息
     *
     * @param warehouseCodeList 渠道仓编码集合
     * @return 渠道仓信息和关联的逻辑仓信息
     */
    @PostMapping(value = "/queryByWarehouseCodeList", produces = "application/json")
    @ApiOperation(value = "批量根据渠道仓库编码查询渠道仓信息和关联的逻辑仓信息", notes = "批量根据渠道仓库编码查询渠道仓信息和关联的逻辑仓信息")
    RestResponse<List<CsChannelWarehouseRespDto>> queryByWarehouseCodeList(@RequestBody List<String> warehouseCodeList);

}
