/**
 * @(#)CsPhysicsWarehouseQueryApi.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseExposedAddReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
* 逻辑仓暴露给PCP应用层的相关操作接口
*
* @author jingran
* @Date: 2021/12/29 11:15
* @since 1.0.0
*/
@Api(tags = {"逻辑仓暴露给PCP应用层的相关操作接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csLogicWarehouseExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLogicWarehouseExposedApi {

    /**
     * 新增逻辑仓仓库
     *
     * @param csLogicWarehouseExposedAddReqDto
     * @return
     */
    @PostMapping(value = "/addLogicWarehouse", produces = "application/json")
    @ApiOperation(value = "新增逻辑仓仓库", notes = "新增逻辑仓仓库")
    RestResponse<Long> addLogicWarehouse(@RequestBody CsLogicWarehouseExposedAddReqDto csLogicWarehouseExposedAddReqDto);

    /**
     * 编辑物理仓仓库
     *
     * @param csLogicWarehouseExposedAddReqDto
     * @return
     */
    @PostMapping(value = "/updatePhysicsWarehouse", produces = "application/json")
    @ApiOperation(value = "编辑物理仓仓库", notes = "编辑物理仓仓库")
    RestResponse<Boolean> updateLogicWarehouse(@RequestBody CsLogicWarehouseExposedAddReqDto csLogicWarehouseExposedAddReqDto);

    /**
     * 批量启用禁用逻辑仓
     *
     * @param ids,status (optional)
     * @return 成功 (status code 200)
     */
    @PostMapping(value = "/modifyPhysicalWarehouseStatus", produces = "application/json")
    @ApiOperation(value = "批量启用禁用逻辑仓,status=enable启用status=disable禁用", notes = "批量启用禁用逻辑仓,status=enable启用status=disable禁用")
    RestResponse<List<String>> modifyPhysicalWarehouseStatus(@Validated @RequestBody List<String> ids, @RequestParam("status") String status);
}