/**
 * @(#)CsPhysicsWarehouseQueryApi.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehouseParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicRelChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 逻辑仓暴露给PCP应用层的相关查询接口
 *
 * @author jingran
 * @Date: 2021/12/29 11:15
 * @since 1.0.0
 */
@Api(tags = {"逻辑仓暴露给PCP应用层的相关查询接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csLogicWarehouseExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsLogicWarehouseExposedQueryApi {

    /**
     * 根据id查询逻辑仓详情
     *
     * @param id 物理仓仓库ID
     * @return
     */
    @GetMapping(value = "/{id}/queryDetailById", produces = "application/json")
    @ApiOperation(value = "根据id查询逻辑仓详情", notes = "根据id查询逻辑仓详情")
    RestResponse<CsLogicWarehouseDetailRespDto> queryDetailById(@PathVariable("id") Long id);

    /**
     * 逻辑仓分页列表查询
     *
     * @param csLogicWarehousePageQueryDto 请求DTO
     * @return
     */
    @PostMapping(value = "/queryPageInfo", produces = "application/json")
    @ApiOperation(value = "逻辑仓分页列表查询", notes = "逻辑仓分页列表查询")
    RestResponse<PageInfo<CsLogicWarehousePageRespDto>> queryPageInfo(@RequestBody CsLogicWarehousePageQueryDto csLogicWarehousePageQueryDto);

    /**
     * 逻辑仓根据参数进行列表查询
     *
     * @param csLogicWarehouseParamQueryDto 请求DTO
     * @return
     */
    @PostMapping(value = "/queryParam", produces = "application/json")
    @ApiOperation(value = "逻辑仓根据参数进行列表查询", notes = "逻辑仓根据参数进行列表查询")
    RestResponse<List<CsLogicWarehousePageRespDto>> queryParam(@RequestBody CsLogicWarehouseParamQueryDto csLogicWarehouseParamQueryDto);

    /**
     * 批量根据逻辑仓编码，查询关联的渠道仓信息，返回逻辑仓关联的渠道仓信息
     *
     * @param logicWarehouseList 逻辑仓编码集合
     * @return 逻辑仓关联的渠道仓信息
     */
    @PostMapping(value = "/queryLogicRelChannelWarehouse", produces = "application/json")
    @ApiOperation(value = "批量根据逻辑仓编码，查询关联的渠道仓信息", notes = "批量根据逻辑仓编码，查询关联的渠道仓信息")
    RestResponse<List<CsLogicRelChannelWarehouseRespDto>> queryLogicRelChannelWarehouse(@Validated @RequestBody List<String> logicWarehouseList);

    /**
     * 根据逻辑仓编码查询逻辑仓主体信息
     *
     * @param warehouseCode 逻辑仓编码
     * @return 仓库类型
     */
    @GetMapping(value = "/queryWarehouseTypeByCode", produces = "application/json")
    @ApiOperation(value = "根据逻辑仓编码查询逻辑仓主体信息", notes = "根据逻辑仓编码查询逻辑仓主体信息")
    RestResponse<CsLogicWarehouseRespDto> queryWarehouseTypeByCode(@RequestParam("warehouseCode") String warehouseCode);

}
