/**
 * @(#)CsPhysicsWarehouseQueryApi.java 1.0 2021/12/29 11:15
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsPhysicsWarehouseExposedAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsPhysicsWarehouseDetailRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
* 物理仓暴露给PCP应用层的相关操作接口
*
* @author jingran
* @Date: 2021/12/29 11:15
* @since 1.0.0
*/
@Api(tags = {"物理仓暴露给PCP应用层的相关操作接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csPhysicsWarehouseExposed", url = "${yundt.cube.center.inventory.api:}")
public interface ICsPhysicsWarehouseExposedApi {

    /**
     * 新增物理仓仓库
     *
     * @param csPhysicsWarehouseExposedAddReqDto
     * @return
     */
    @PostMapping(value = "/addPhysicsWarehouse", produces = "application/json")
    @ApiOperation(value = "新增物理仓仓库", notes = "新增物理仓仓库")
    RestResponse<Long> addPhysicsWarehouse(@RequestBody CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto);

    /**
     * 编辑物理仓仓库
     *
     * @param csPhysicsWarehouseExposedAddReqDto
     * @return
     */
    @PostMapping(value = "/updatePhysicsWarehouse", produces = "application/json")
    @ApiOperation(value = "编辑物理仓仓库", notes = "编辑物理仓仓库")
    RestResponse<Boolean> updatePhysicsWarehouse(@RequestBody CsPhysicsWarehouseExposedAddReqDto csPhysicsWarehouseExposedAddReqDto);

    /**
     * 批量启用/禁用物理仓
     *
     * @param
     * @return
     */
    @PutMapping(value = "/modifyPhysicalWarehouseStatus")
    @ApiOperation(value = "批量启用/禁用物理仓,type=enable启用type=disable禁用", notes = "批量启用/禁用物理仓,type=enable启用type=disable禁用")
    RestResponse<Void> modifyPhysicalWarehouseStatus(@RequestParam("ids") String ids, @RequestParam("status") String status);
}