/**
 * @(#)CsRelWarehouseQueryApi.java 1.0 2022/01/10 11:13
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsPhysicsInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsRelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsRelWarehouseRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * CsRelWarehouseQueryApi
 *
 * @author jingran
 * @Date: 2022/01/10 11:13
 * @since 1.0.0
 */
@Api(tags = {"CsRelWarehouse接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name: yundt-cube-center-inventory}", path = "/v2/csRelWarehouse", url = "${yundt.cube.center.inventory.api:}")
public interface ICsRelWarehouseQueryApi {

    /**
     * 根据id查询信息
     *
     * @param id
     * @return
     */
    @GetMapping(value = "/{id}/queryByPrimaryKey", produces = "application/json")
    @ApiOperation(value = "根据id查询信息", notes = "根据id查询信息")
    RestResponse<CsRelWarehouseRespDto> queryByPrimaryKey(@PathVariable("id") Long id);

    /**
     * 分页查询
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    RestResponse<PageInfo<CsRelWarehouseRespDto>> queryByPage(@Validated @RequestBody CsRelWarehouseQueryDto queryDto);

    /**
     * 根据条件获取关联的渠道信息
     *
     * @param queryDto
     * @return
     */
    @PostMapping(value = "/queryWarehouseByConditions", produces = "application/json")
    @ApiOperation(value = "根据条件获取关联的渠道信息", notes = "根据条件获取关联的渠道信息")
    RestResponse<List<CsRelWarehouseRespDto>> queryWarehouseByConditions(@Validated @RequestBody CsRelWarehouseQueryDto queryDto);

}