package com.dtyunxi.yundt.cube.center.inventory.api.dto.request;

import java.util.Date;

import com.dtyunxi.dto.BasePageDto;
import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
* 仓库区域映射规则Eo对象
*
* @author 妙才
* @since 2022-12-24
*/
@Getter
@Setter
@ApiModel(value = "WarehouseAreaMappingReqDto", description = "仓库区域映射规则Eo对象")
public class WarehouseAreaMappingReqDto extends BasePageDto {
    /**
    *  主键
    */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;
    @ApiModelProperty(name = "ids", value = "ids")
    private List<Long> ids;
    /**
    *  规则编码
    */
    @ApiModelProperty(name = "code", value = "规则编码")
    private String code;
    /**
    *  发货类型
    */
    @ApiModelProperty(name = "type", value = "发货类型")
    private String type;
    /**
    *  省份
    */
    @ApiModelProperty(name = "province", value = "省份")
    private String province;
    @ApiModelProperty(name = "provinceList", value = "省份")
    private List<String> provinceList;
    /**
    *  省份编码
    */
    @ApiModelProperty(name = "provinceCode", value = "省份编码")
    private String provinceCode;
    @ApiModelProperty(name = "provinceCodeList", value = "省份编码集合")
    private List<String> provinceCodeList;
    /**
    *  寻源物理仓库
    */
    @ApiModelProperty(name = "sourceWarehouse", value = "寻源物理仓库")
    private String sourceWarehouse;
    /**
    *  寻源物理仓库编码
    */
    @ApiModelProperty(name = "sourceWarehouseCode", value = "寻源物理仓库编码")
    private String sourceWarehouseCode;

    @ApiModelProperty(name = "sourceWarehouseCodeList", value = "寻源物理仓库编码集合")
    private List<String> sourceWarehouseCodeList;

    /**
    *  中转物理仓库
    */
    @ApiModelProperty(name = "centerWarehouse", value = "中转物理仓库")
    private String centerWarehouse;
    /**
    *  中转物理仓库编码
    */
    @ApiModelProperty(name = "centerWarehouseCode", value = "中转物理仓库编码")
    private String centerWarehouseCode;
    /**
    *  调入物理仓库
    */
    @ApiModelProperty(name = "inWarehouse", value = "调入物理仓库")
    private String inWarehouse;
    /**
    *  调入物理仓库编码
    */
    @ApiModelProperty(name = "inWarehouseCode", value = "调入物理仓库编码")
    private String inWarehouseCode;
    /**
    *  状态 1.开启 0.关闭
    */
    @ApiModelProperty(name = "status", value = "状态 1.开启 0.关闭")
    private Integer status;
    /**
    *  业务时间
    */
    @ApiModelProperty(name = "bizDate", value = "业务时间")
    private Date bizDate;
    /**
    *  组织id
    */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;
    /**
    *  组织编码
    */
    @ApiModelProperty(name = "organizationCode", value = "组织编码")
    private String organizationCode;
    /**
    *  组织名称
    */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;
    /**
    *  备注
    */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

}
