package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.AdjustmentInventoryAuditRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
 * 盘点单服务接口
 *
 * @author author
 * @since 2022-07-12
 */
@Api(tags = {"盘点单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IAdjustmentInventoryApi",
        name = "${yundt.cube.center.inventory.api.name:cis-yundt-cube-center-inventory}",
        path = "/v1/adjustmentInventory",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface IAdjustmentInventoryApi {

    /**
     * 新增盘点单
     *
     * @param addReqDto 盘点单请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增盘点单", notes = "新增盘点单")
    RestResponse<Long> addAdjustmentInventory(@RequestBody AdjustmentInventoryReqDto addReqDto);

    /**
     * 修改盘点单
     *
     * @param modifyReqDto 盘点单请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改盘点单", notes = "修改盘点单")
    RestResponse<Void> modifyAdjustmentInventory(@RequestBody AdjustmentInventoryReqDto modifyReqDto);

    /**
     * 删除盘点单
     *
     * @param ids        盘点单删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除盘点单", notes = "删除盘点单")
    RestResponse<Void> removeAdjustmentInventory(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    @PutMapping("/close")
    @ApiOperation(value = "关闭盘点单", notes = "关闭盘点单")
    RestResponse<Void> closeAdjustmentInventory(@RequestParam Long id, @RequestParam("remark") String remark);

    @PutMapping("/audit")
    @ApiOperation(value = "审核盘点单", notes = "审核盘点单")
    RestResponse<Void> auditAdjustmentInventory(@RequestBody AdjustmentInventoryAuditRespDto dto);
}
