package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryAuditReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
 * 库存调整单的审核信息服务接口
 *
 * @author author
 * @since 2022-07-12
 */
@Api(tags = {"库存调整单的审核信息服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IAdjustmentInventoryAuditApi",
        name = "${yundt.cube.center.inventory.api.name:cis-yundt-cube-center-inventory}",
        path = "/v1/adjustmentInventoryAudit",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface IAdjustmentInventoryAuditApi {

    /**
     * 新增库存调整单的审核信息
     *
     * @param addReqDto 库存调整单的审核信息请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增库存调整单的审核信息", notes = "新增库存调整单的审核信息")
    RestResponse<Long> addAdjustmentInventoryAudit(@RequestBody AdjustmentInventoryAuditReqDto addReqDto);

    /**
     * 修改库存调整单的审核信息
     *
     * @param modifyReqDto 库存调整单的审核信息请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改库存调整单的审核信息", notes = "修改库存调整单的审核信息")
    RestResponse<Void> modifyAdjustmentInventoryAudit(@RequestBody AdjustmentInventoryAuditReqDto modifyReqDto);

    /**
     * 删除库存调整单的审核信息
     *
     * @param ids        库存调整单的审核信息删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除库存调整单的审核信息", notes = "删除库存调整单的审核信息")
    RestResponse<Void> removeAdjustmentInventoryAudit(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
