package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.AdjustmentInventoryDetailReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 库存调整单明细服务接口
*
* @author author
* @since 2022-07-12
*/
@Api(tags = {"库存调整单明细服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IAdjustmentInventoryDetailApi",
    name = "${yundt.cube.center.inventory.api.name:cis-yundt-cube-center-inventory}",
    path = "/v1/adjustmentInventoryDetail",
    url = "${yundt.cube.center.inventory.api:}"
)
public interface IAdjustmentInventoryDetailApi {

/**
* 新增库存调整单明细
*
* @param addReqDto 库存调整单明细请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增库存调整单明细", notes = "新增库存调整单明细")
RestResponse<Long> addAdjustmentInventoryDetail(@RequestBody AdjustmentInventoryDetailReqDto addReqDto);

    /**
    * 修改库存调整单明细
    *
    * @param modifyReqDto 库存调整单明细请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改库存调整单明细", notes = "修改库存调整单明细")
    RestResponse<Void> modifyAdjustmentInventoryDetail(@RequestBody AdjustmentInventoryDetailReqDto modifyReqDto);

    /**
    * 删除库存调整单明细
    *
    * @param ids        库存调整单明细删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除库存调整单明细", notes = "删除库存调整单明细")
    RestResponse<Void> removeAdjustmentInventoryDetail(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
