package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsBusinessTypeReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 业务类型表服务接口
 *
 * @author wuyue
 * @since 2022-04-26
 */
@Api(tags = {"业务类型表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsBusinessTypeApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/business/type",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsBusinessTypeApi {

    /**
     * 新增业务类型表
     *
     * @param addReqDto 业务类型表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增业务类型表", notes = "新增业务类型表")
    RestResponse<Long> addCsBusinessType(@RequestBody CsBusinessTypeReqDto addReqDto);

    /**
     * 修改业务类型表
     *
     * @param modifyReqDto 业务类型表请求对象
     * @return 处理结果
     */
    @PutMapping("/modifyCsBusinessType")
    @ApiOperation(value = "修改业务类型表", notes = "修改业务类型表")
    RestResponse<Void> modifyCsBusinessType(@RequestBody CsBusinessTypeReqDto modifyReqDto);

    /**
     * 删除业务类型表
     *
     * @param ids 业务类型表删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除业务类型表", notes = "删除业务类型表")
    RestResponse<Void> removeCsBusinessType(@PathVariable("ids") String ids);

    /**
     * 编辑业务类型状态
     *
     * @param modifyReqDto 编辑业务类型状态
     * @return 处理结果
     */
    @PutMapping("/modifyCsBusinessTypeStatus")
    @ApiOperation(value = "编辑业务类型状态", notes = "编辑业务类型状态")
    RestResponse<Void> modifyCsBusinessTypeStatus(@RequestBody CsBusinessTypeReqDto modifyReqDto);
}
