package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.response.es.CsOtherStorageOrderRespVo;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.*;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.OtherStorageAuditBatchReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 其他出入库单服务接口
 *
 * @author wuyue
 * @since 2022-04-25
 */
@Api(tags = {"其他出入库单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsOtherStorageOrderApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/other/storage/order",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsOtherStorageOrderApi {

    /**
     * 新增其他出入库单
     *
     * @param csOtherStorageOrderComboReqDto 其他出入库单请求对象
     * @return 处理结果
     */
    @PostMapping("/addCsOtherStorageOrder")
    @ApiOperation(value = "新增其他出入库单", notes = "新增其他出入库单")
    RestResponse<Long> addCsOtherStorageOrder(@RequestBody CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto);

    /**
     * 批量新增其他出入库单
     *
     * @param list 其他出入库单请求对象
     * @return 处理结果
     */
    @PostMapping("/batchAddCsOtherStorageOrder")
    @ApiOperation(value = "批量新增其他出入库单", notes = "批量新增其他出入库单")
    RestResponse<Map<String, String>> batchAddCsOtherStorageOrder(@RequestBody List<CsOtherStorageOrderComboReqDto> list);

    /**
     * 新增其他出入库单
     *
     * @param csStorageOrderCallBackReqDto 其他出入库单请求对象
     * @return 处理结果
     */
    @PostMapping("/storageOrderCallBack")
    @ApiOperation(value = "第三方单据回传", notes = "第三方单据回传")
    RestResponse<String> storageOrderCallBack(@RequestBody CsStorageOrderCallBackReqDto csStorageOrderCallBackReqDto);

    /**
     * 保存其他出入库单
     *
     * @param csOtherStorageOrderComboReqDto 其他出入库单请求对象
     * @return 处理结果
     */
    @PostMapping("/saveCsOtherStorageOrder")
    @ApiOperation(value = "保存其他出入库单", notes = "保存其他出入库单")
    RestResponse<Long> saveCsOtherStorageOrder(@RequestBody CsOtherStorageOrderComboReqDto csOtherStorageOrderComboReqDto);

    /**
     * 修改其他出入库单
     *
     * @param modifyReqDto 其他出入库单请求对象
     * @return 处理结果
     */
    @PutMapping("/modifyCsOtherStorageOrder")
    @ApiOperation(value = "修改其他出入库单", notes = "修改其他出入库单")
    RestResponse<Void> modifyCsOtherStorageOrder(@RequestBody CsOtherStorageOrderComboReqDto modifyReqDto);

    /**
     * 根据id,提交
     *
     * @param id 其他出入库单id
     * @return 处理结果
     */
    @PutMapping("/submitById/{id}")
    @ApiOperation(value = "根据id,提交", notes = "根据id,提交")
    RestResponse<Void> submitById(@PathVariable("id") Long id);

    /**
     * 删除其他出入库单
     *
     * @param ids        其他出入库单删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除其他出入库单", notes = "删除其他出入库单")
    RestResponse<Void> removeCsOtherStorageOrder(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 删除其他出入库单
     *
     * @param id 其他出入库单删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/deleteById/{id}")
    @ApiOperation(value = "删除其他出入库单", notes = "删除其他出入库单")
    RestResponse<Void> deleteById(@PathVariable("id") Long id);

    /**
     * 审核其他出入库单
     *
     * @param auditReqDto 其他出入库单请求对象
     * @return 处理结果
     */
    @PutMapping("/auditCsOtherStorageOrder")
    @ApiOperation(value = "审核其他出入库单", notes = "审核其他出入库单")
    RestResponse<Void> auditCsOtherStorageOrder(@RequestBody CsOtherStorageOrderAuditReqDto auditReqDto);

    @PutMapping("/rollbackOutLogicInventory")
    @ApiOperation(value = "释放其他出库预占", notes = "释放其他出库预占")
    RestResponse<Void> rollbackOutLogicInventory(@RequestBody CsOtherStorageOrderRespDto respDto);

    /**
     * 修改其他出入库单
     *
     * @param csStorageCancelHangUpReqDto 其他出入库单请求对象
     * @return 处理结果
     */
    @PutMapping("/cancelHangUpStorageOrder")
    @ApiOperation(value = "解挂", notes = "解挂")
    RestResponse<Void> cancelHangUpStorageOrder(@RequestBody @Validated CsStorageCancelHangUpReqDto csStorageCancelHangUpReqDto);

    /**
     * 结果单据数据调整
     *
     * @param csStorageAdjustReqDto 结果单据数据调整请求对象
     * @return 处理结果
     */
    @PutMapping("/adjustStorageResultOrder")
    @ApiOperation(value = "结果单据数据调整", notes = "结果单据数据调整")
    RestResponse<Void> adjustStorageResultOrder(@RequestBody @Validated CsStorageAdjustReqDto csStorageAdjustReqDto);

    /**
     * 测试发送mq
     *
     * @param csStorageSendMqReqDto csStorageSendMqReqDto
     * @return void
     */
    @PostMapping("/testSendMq")
    RestResponse<Void> testSendMq(@RequestBody CsStorageSendMqReqDto csStorageSendMqReqDto);

    /**
     * sda
     *
     * @param csStorageSendMqReqDto csStorageSendMqReqDto
     * @return void
     */
    @PostMapping("/testMq")
    RestResponse<Void> testMq(@RequestBody CsStorageSendMqReqDto csStorageSendMqReqDto);

    /**
     * batchCreateCsOtherStorageOrder
     *
     * @param list 其他出入库单请求对象
     * @return 处理结果
     */
    @PostMapping("/batchCreateCsOtherStorageOrder")
    @ApiOperation(value = "批量新增其他出入库单(导入专用)", notes = "批量新增其他出入库单(导入专用)")
    RestResponse<Void> batchCreateCsOtherStorageOrder(@RequestBody @Validated List<CsOtherStorageOrderComboReqDto> list);

    /**
     * batchCreateCsOtherStorageOrder
     *
     * @param auditBatchReqDto 其他出入库单请求对象
     * @return 处理结果
     */
    @PostMapping("/batchAuditCsOtherStorageOrder")
    @ApiOperation(value = "批量新增其他出入库单(导入专用)", notes = "批量新增其他出入库单(导入专用)")
    RestResponse<Void> batchAuditCsOtherStorageOrder(@RequestBody @Validated OtherStorageAuditBatchReqDto auditBatchReqDto);

    /**
     * 编辑其他出入库，更新外部单号
     *
     * @param otherStorageOrderEditReqDto 其他出入库单请求对象
     * @return 处理结果
     */
    @PostMapping("/editOtherStorageOrder")
    @ApiOperation(value = "编辑其他出入库，更新外部单号", notes = "编辑其他出入库，更新外部单号")
    RestResponse<Void> editOtherStorageOrder(@RequestBody @Validated CsOtherStorageOrderEditReqDto otherStorageOrderEditReqDto);

    @PostMapping("/modifyOtherOut")
    @ApiOperation(value = "修改其他出库单", notes = "修改其他出库单")
    RestResponse<Void> modifyOtherOut(@RequestBody CsOtherStorageOrderReqDto csOtherStorageOrderReqDto);


}
