package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderDetailReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 其他出入库单明细服务接口
 *
 * @author wuyue
 * @since 2022-04-25
 */
@Api(tags = {"其他出入库单明细服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsOtherStorageOrderDetailApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/other/storage/order/detail",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsOtherStorageOrderDetailApi {

    /**
     * 新增其他出入库单明细
     *
     * @param addReqDto 其他出入库单明细请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增其他出入库单明细", notes = "新增其他出入库单明细")
    RestResponse<Long> addCsOtherStorageOrderDetail(@RequestBody CsOtherStorageOrderDetailReqDto addReqDto);

    /**
     * 修改其他出入库单明细
     *
     * @param modifyReqDto 其他出入库单明细请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改其他出入库单明细", notes = "修改其他出入库单明细")
    RestResponse<Void> modifyCsOtherStorageOrderDetail(@RequestBody CsOtherStorageOrderDetailReqDto modifyReqDto);

    /**
     * 删除其他出入库单明细
     *
     * @param ids        其他出入库单明细删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除其他出入库单明细", notes = "删除其他出入库单明细")
    RestResponse<Void> removeCsOtherStorageOrderDetail(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
