package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageAuditRecordReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 单据审核记录表服务接口
 *
 * @author wuyue
 * @since 2022-04-25
 */
@Api(tags = {"单据审核记录表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsStorageAuditRecordApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/storage/audit/record",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsStorageAuditRecordApi {

    /**
     * 新增单据审核记录表
     *
     * @param addReqDto 单据审核记录表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增单据审核记录表", notes = "新增单据审核记录表")
    RestResponse<Long> addCsStorageAuditRecord(@RequestBody CsStorageAuditRecordReqDto addReqDto);

    /**
     * 修改单据审核记录表
     *
     * @param modifyReqDto 单据审核记录表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改单据审核记录表", notes = "修改单据审核记录表")
    RestResponse<Void> modifyCsStorageAuditRecord(@RequestBody CsStorageAuditRecordReqDto modifyReqDto);

    /**
     * 删除单据审核记录表
     *
     * @param ids        单据审核记录表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除单据审核记录表", notes = "删除单据审核记录表")
    RestResponse<Void> removeCsStorageAuditRecord(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
