package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsStorageSnCodeReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 单据串码表服务接口
 *
 * @author wuyue
 * @since 2022-04-25
 */
@Api(tags = {"单据串码表服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsStorageSnCodeApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/storage/sn/code",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsStorageSnCodeApi {

    /**
     * 新增单据串码表
     *
     * @param addReqDto 单据串码表请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增单据串码表", notes = "新增单据串码表")
    RestResponse<Long> addCsStorageSnCode(@RequestBody CsStorageSnCodeReqDto addReqDto);

    /**
     * 修改单据串码表
     *
     * @param modifyReqDto 单据串码表请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改单据串码表", notes = "修改单据串码表")
    RestResponse<Void> modifyCsStorageSnCode(@RequestBody CsStorageSnCodeReqDto modifyReqDto);

    /**
     * 删除单据串码表
     *
     * @param ids        单据串码表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除单据串码表", notes = "删除单据串码表")
    RestResponse<Void> removeCsStorageSnCode(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);
}
