package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.*;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.external.wms.CsBasicsCancelReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 调拨单
 *
 * @author wuyue
 * @since 2022-05-17
 */
@Api(tags = {"调拨单服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsTransferOrderApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/cs/transfer/order",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsTransferOrderApi {

    /**
     * 新增业调拨单
     *
     * @param addReqDto 新增业调拨单
     * @return 处理结果
     */
    @Deprecated
    @PostMapping("")
    @ApiOperation(value = "新增业调拨单(废弃)", notes = "新增业调拨单(废弃)")
    RestResponse<Long> addCsTransferOrder(@RequestBody CsTransferOrderReqDto addReqDto);

    /**
     * 新增调拨单表
     *
     * @param csTransferOrderComboReqDto 调拨单请求对象
     * @return 处理结果
     */
    @PostMapping("/addTransferOrder")
    @ApiOperation(value = "新增调拨单", notes = "新增调拨单")
    RestResponse<Long> addTransferOrder(@RequestBody CsTransferOrderComboReqDto csTransferOrderComboReqDto);

    @PostMapping("/addTransferOrders")
    @ApiOperation(value = "批量新增调拨单", notes = "批量新增调拨单")
    RestResponse<Void> addTransferOrders(@RequestBody List<CsTransferOrderComboReqDto> csTransferOrderComboReqDtoList);

    /**
     * Eas新增调拨单表
     *
     * @param easTransferOrderDetailReqDto 调拨单请求对象
     * @return 处理结果
     */
    @PostMapping("/easAddTransferOrder")
    @ApiOperation(value = "Eas新增调拨单表", notes = "Eas新增调拨单表")
    RestResponse<Long> easAddTransferOrder(@RequestBody @Validated EasTransferOrderReqDto easTransferOrderDetailReqDto);

    /**
     * Eas批量新增内部调拨单
     *
     * @param easTransferOrderReqDtoList 调拨单请求对象
     * @return 处理结果
     */
    @PostMapping("/batchEasAddTransferOrder")
    @ApiOperation(value = "Eas批量新增内部调拨单", notes = "Eas批量新增内部调拨单")
    RestResponse<Void> batchEasAddTransferOrder(@RequestBody @Validated List<EasTransferOrderReqDto> easTransferOrderReqDtoList);

    /**
     * Eas新增/修改内部交易调拨单表
     *
     * @param easTransferOrderDetailReqDto 调拨单请求对象
     * @return 处理结果
     */
    @PostMapping("/easInsiderTradeTransferOrder")
    @ApiOperation(value = "Eas新增/修改内部交易调拨单表", notes = "Eas新增/修改内部交易调拨单表")
    RestResponse<Long> easInsiderTradeTransferOrder(@RequestBody @Validated EasTransferOrderReqDto easTransferOrderDetailReqDto);


    /**
     * 修改业调拨单
     *
     * @param modifyReqDto 调拨单请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改业调拨单", notes = "修改业调拨单")
    RestResponse<Void> modifyCsTransferOrder(@RequestBody CsTransferOrderComboReqDto modifyReqDto);

    /**
     * 删除业调拨单
     *
     * @param ids 删除业调拨单
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除业调拨单", notes = "删除业调拨单")
    RestResponse<Void> removeCsTransferOrder(@PathVariable("ids") String ids);

    /**
     * 关闭业调拨单
     *
     * @param transferOrderNo transferOrderNo
     * @return 处理结果
     */
    @PutMapping("/closeTransferOrder/{transferOrderNo}")
    @ApiOperation(value = "关闭业调拨单", notes = "关闭业调拨单")
    RestResponse<Void> closeTransferOrder(@PathVariable("transferOrderNo") String transferOrderNo);

    /**
     *
     *
     * @param csAuditReqDto csAuditReqDto
     * @return 处理结果
     */
    @PutMapping("/auditTransferOrder")
    @ApiOperation(value = "审核调拨单", notes = "审核调拨单")
    RestResponse<Void> auditTransferOrder(@RequestBody CsAuditReqDto csAuditReqDto);

    /**
     * 审核调拨单
     *
     * @param cancelTransferOrder cancelTransferOrder
     * @return 处理结果
     */
    @PutMapping("/cancelTransferOrder")
    @ApiOperation(value = "取消调拨单", notes = "取消调拨单")
    RestResponse<Void> cancelTransferOrder(@RequestBody CsCancelTransferOrderReqDto cancelTransferOrder);

    /**
     * 追加调拨单扩展信息
     *
     * @param csTransferOrderReqDto 请求参数
     * @return 处理结果
     */
    @PutMapping("/modifyCsTransferOrderExtension")
    @ApiOperation(value = "追加调拨单扩展信息", notes = "追加调拨单扩展信息")
    RestResponse<Void> modifyCsTransferOrderExtension(@RequestBody CsTransferOrderReqDto csTransferOrderReqDto);

    /**
     * 根据通知单取消调拨单
     *
     * @param basicsCancelReqDto
     * @return
     */
    @PostMapping(value = "/cancelInstruct", produces = "application/json")
    @ApiOperation(value = "根据通知单取消调拨单", notes = "根据通知单取消调拨单")
    RestResponse<String> cancelInstruct(@Validated @RequestBody CsBasicsCancelReqDto basicsCancelReqDto);

    @PostMapping(value = "/getTransferOrderNo", produces = "application/json")
    @ApiOperation(value = "获取调拨单单号", notes = "获取调拨单单号")
    RestResponse<String> getTransferOrderNo();

    @PostMapping(value = "/hasAllDelivery", produces = "application/json")
    @ApiOperation(value = "根据一组调拨单号, 判断是不是都发货了", notes = "根据一组调拨单号, 判断是不是都发货了")
    RestResponse<Boolean> hasAllDelivery(@RequestBody List<String> transferNos);
}
