package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsTransferOrderDetailReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 调拨单明细明细服务接口
 *
 * @author wuyue
 * @since 2022-05-17
 */
@Api(tags = {"调拨单明细服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-ICsTransferOrderDetailApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/cs/transfer/order/detail",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface ICsTransferOrderDetailApi {

    /**
     * 新增调拨单明细明细
     *
     * @param addReqDto 新增调拨单明细明细
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增调拨单明细明细", notes = "新增调拨单明细明细")
    RestResponse<Long> addCsTransferOrderDetail(@RequestBody CsTransferOrderDetailReqDto addReqDto);

    /**
     * 修改调拨单明细明细
     *
     * @param modifyReqDto 修改调拨单明细明细
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改调拨单明细明细", notes = "修改调拨单明细明细")
    RestResponse<Void> modifyCsTransferOrderDetail(@RequestBody CsTransferOrderDetailReqDto modifyReqDto);

    /**
     * 删除调拨单明细明细
     *
     * @param ids        删除调拨单明细明细
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除调拨单明细明细", notes = "删除调拨单明细明细")
    RestResponse<Void> removeCsTransferOrderDetail(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

    /**
     * 追加调拨单明细明细扩展信息
     * @param reqDtoList 明细信息
     * @return 处理结果
     */
    @PostMapping("/modifyCsTransferOrderDetailExtension")
    @ApiOperation(value = "追加调拨单明细明细扩展信息", notes = "追加调拨单明细明细扩展信息")
    RestResponse<Void> modifyCsTransferOrderDetailExtension(@RequestBody List<CsTransferOrderDetailReqDto> reqDtoList);
}
