package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.InternalTradeReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
* 内部交易（多方调拨）服务接口
*
* @author jiejun
* @since 2022-07-30
*/
@Api(tags = {"内部交易（多方调拨）服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IInternalTradeApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/cs/internalTrade",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface IInternalTradeApi {

    /**
     * 批量新增内部交易（多方调拨）单据信息
     * @param reqDtoList 请求参数
     * @return 处理结果
     */
    @PostMapping("/addBatchInternalTrade")
    @ApiOperation(value = "批量新增内部交易（多方调拨）单据信息", notes = "批量新增内部交易（多方调拨）单据信息")
    RestResponse<Void> addBatchInternalTrade(@RequestBody List<InternalTradeReqDto> reqDtoList);

    /**
     * 修改内部交易（多方调拨）
     * @param modifyReqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/modifyInternalTrade")
    @ApiOperation(value = "修改内部交易（多方调拨）", notes = "修改内部交易（多方调拨）")
    RestResponse<Void> modifyInternalTrade(@RequestBody InternalTradeReqDto modifyReqDto);

    /**
     * 删除内部交易（多方调拨）
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/removeInternalTrade")
    @ApiOperation(value = "删除内部交易（多方调拨）", notes = "删除内部交易（多方调拨）")
    RestResponse<Void> removeInternalTrade(@RequestBody InternalTradeReqDto reqDto);

    /**
     * 执行下一个交易（销售退转内部交易）
     * @param reqDto 请求参数
     * @return 处理结果
     */
    @PostMapping("/nextInternalTrade")
    @ApiOperation(value = "执行下一个交易（销售退转内部交易）", notes = "执行下一个交易（销售退转内部交易）")
    RestResponse<Void> nextInternalTrade(@RequestBody InternalTradeReqDto reqDto);

    @PostMapping("/executeNext")
    @ApiOperation(value = "执行下一个交易（不处理上次交易）", notes = "执行下一个交易（不处理上次交易）")
    RestResponse<Void> executeNext(@RequestBody InternalTradeReqDto reqDto);

//    /**
//    * 新增内部交易（多方调拨）
//    *
//    * @param addReqDto 内部交易（多方调拨）请求对象
//    * @return 处理结果
//    */
//    @PostMapping("")
//    @ApiOperation(value = "新增内部交易（多方调拨）", notes = "新增内部交易（多方调拨）")
//    RestResponse<Long> addInternalTrade(@RequestBody InternalTradeReqDto addReqDto);
//
//    /**
//    * 修改内部交易（多方调拨）
//    *
//    * @param modifyReqDto 内部交易（多方调拨）请求对象
//    * @return 处理结果
//    */
//    @PutMapping("")
//    @ApiOperation(value = "修改内部交易（多方调拨）", notes = "修改内部交易（多方调拨）")
//    RestResponse<Void> modifyInternalTrade(@RequestBody InternalTradeReqDto modifyReqDto);
//
//    /**
//    * 删除内部交易（多方调拨）
//    *
//    * @param ids        内部交易（多方调拨）删除数据ID
//    * @param instanceId 实例ID
//    * @return 处理结果
//    */
//    @DeleteMapping("/{ids}")
//    @ApiOperation(value = "删除内部交易（多方调拨）", notes = "删除内部交易（多方调拨）")
//    RestResponse<Void> removeInternalTrade(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
