package com.dtyunxi.yundt.cube.center.inventory.api.inventory;


import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.InventoryBizDateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 * 库存中心业务时间服务
 * @author jiejun
 */
@Api(tags = {"库存中心业务时间服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-inventory-api-IInventoryBizDateApi",
        name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}",
        path = "/v1/cs/inventoryBizDateApi",
        url = "${yundt.cube.center.inventory.api:}"
)
public interface IInventoryBizDateApi {

    /**
     * 更新单据业务时间
     * @param bizDate 业务时间
     * @param id 单据ID
     * @param no 单据编号
     */
    @PostMapping("/updateBizDate")
    @ApiOperation(value = "更新单据业务时间", notes = "更新单据业务时间")
    RestResponse<Void> updateBizDate(@Validated @RequestBody InventoryBizDateReqDto reqDto);
}
