package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.MqMessageReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryReceiveResultRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * MQ报文（发货/收货通知单）服务接口
 *
 * @author 杰俊
 * @since 2021-09-28
 */
@Api(tags = {"MQ报文（发货/收货通知单）服务"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}", path = "/v1/mqMessage", url = "${yundt.cube.center.inventory.api:}")
public interface IMqMessageApi {

    /**
     * 新增MQ报文并发送发货通知单MQ至营销云
     *
     * @param dto 请求对象
     */
    @PostMapping("/sendDeliverOrderInform")
    @ApiOperation(value = "新增MQ报文并发送发货通知单MQ至营销云", notes = "新增MQ报文并发送发货通知单MQ至营销云")
    RestResponse<Void> sendDeliverOrderInform(@RequestBody MqContentOrderDto dto);

    /**
     * 新增MQ报文并发送收货通知单MQ至营销云
     *
     * @param dto 请求对象
     */
    @PostMapping("/sendReceiveOrderInformMq")
    @ApiOperation(value = "新增MQ报文并发送收货通知单MQ至营销云", notes = "新增MQ报文并发送收货通知单MQ至营销云")
    RestResponse<Void> sendReceiveOrderInformMq(@RequestBody MqContentOrderDto dto);

    /**
     * 修复表“in_mq_message”字段"no"的数据数据信息
     *
     * @return 执行结果
     */
    @GetMapping("/repairDataOfNo")
    @ApiOperation(value = "修复表'in_mq_message'字段'no'的数据数据信息", notes = "修复表“in_mq_message”字段'no'的数据数据信息")
    RestResponse<String> repairDataOfNo();

    /**
     * 添加mq日志信息
     *
     * @param mqMessageReqDto  mqMessageReqDto
     * @return id
     */
    @PostMapping("/addMqMessage")
    @ApiOperation(value = "添加mq日志信息", notes = "添加mq日志信息")
    RestResponse<Long> addMqMessage(@RequestBody MqMessageReqDto mqMessageReqDto);

//    /**
//     * 手动回传结果单至EAS
//     * @param dto 请求参数
//     * @return 执行结果
//     */
//    @PostMapping("/sendResultOrderToEas")
//    @ApiOperation(value = "手动回传结果单至EAS", notes = "手动回传结果单至EAS")
//    RestResponse<String> sendResultOrderToEas(@RequestBody CsDeliveryReceiveResultRespDto dto);

//    /**
//     * 手动取消单据至EAS
//     * @param type 类型
//     * @param orderNo 外部单据号
//     * @return 执行结果
//     */
//    @GetMapping("/sendOrderCancelToEas")
//    @ApiOperation(value = "手动取消单据至EAS", notes = "手动取消单据至EAS")
//    RestResponse<String> sendOrderCancelToEas(@RequestParam("type") String type,@RequestParam("orderNo") String orderNo);

//    /**
//     * 发送收发货结果MQ外部服务
//     * @param documentNo 收/发结果单号
//     * @return 处理结果
//     */
//    @GetMapping("/sendDeliverReceiveResultToExternal")
//    @ApiOperation(value = "发送收发货结果MQ外部服务", notes = "发送收发货结果MQ外部服务")
//    RestResponse<String> sendDeliverReceiveResultToExternal(@RequestParam("documentNo") String documentNo);
}
